/* $Id: Attribute.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;

/**
 * 属性値を表すインタフェースである。属性値には、プロセス変数のほかに、
 * ユーザ関連データが含まれる。
 * 本ワークフローで認識する型は、文字列型、数値型、真理値型である。
 * 
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Attribute extends WfNameValue
{
	/** 文字列 */
	public static final int STRING    = VariableDefinition.STRING;
	/** 整数 */
	public static final int INTEGER   = VariableDefinition.INTEGER;
	/** 真理値 */
	public static final int BOOLEAN   = VariableDefinition.BOOLEAN;

	/**
	 * 属性の型を返す。
	 *
	 * @return 属性の型
	 */
	public int getType();

	/**
	 * 属性値を設定する
	 *
	 * @param value 属性値
	 */
	public void setValue(String value);
}
