/* $Id: Activity.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.omg.WfObject;

/**
 * アクティビティインスタンスを表すインタフェースである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Activity extends WfObject
{
	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcessID();
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcessID(String procID);

	/**
	 * アクティビティインスタンスIDを取得する。
	 *
	 * @return	アクティビティインスタンスID
	 */
	public String getActivityID();
	
	/**
	 * アクティビティインスタンスIDを設定する。
	 *
	 * @param	actID	アクティビティインスタンスID
	 */
	public void setActivityID(String actID);

	/**
	 * アクティビティインスタンス名を取得する。
	 *
	 * @return	アクティビティインスタンス名
	 */
	public String getName();

	/**
	 * アクティビティ定義IDを取得する。
	 *
	 * @return	アクティビティ定義ID
	 */
	public String getActivityDefinitionID();
	
	/**
	 * アクティビティ定義IDを設定する。
	 *
	 * @param	actDefID	アクティビティ定義ID
	 */
	public void setActivityDefinitionID(String actDefID);

	/**
	 * 開始日時を取得する。
	 *
	 * @return	開始日時
	 */
	public Timestamp getStartDate();
	
	/**
	 * 開始日時を設定する。
	 *
	 * @param	startDate	開始日時
	 */
	public void setStartDate(Timestamp startDate);

	/**
	 * 開始者を取得する。
	 *
	 * @return	開始者
	 */
	public String getStarterID();
	
	/**
	 * 開始者を設定する。
	 *
	 * @param	starterID	開始者
	 */
	public void setStarterID(String starterID);

	/**
	 * 実行期限を取得する。
	 *
	 * @return	実行期限
	 */
	public Timestamp getDurationLimit();
	
	/**
	 * 実行期限を設定する。
	 *
	 * @param	durationLimit	実行期限
	 */
	public void setDurationLimit(Timestamp durationLimit);

	/**
	 * 所属する並行処理ブロックIDを取得する。
	 *
	 * @return	所属する並行処理ブロックID
	 */
	public String getBlockID();
	
	/**
	 * 所属する並行処理ブロックIDを設定する。
	 *
	 * @param	blockID	所属する並行処理ブロックID
	 */
	public void setBlockID(String blockID);

	/**
	 * 状態を取得する。
	 *
	 * @return	状態
	 */
	public int getActivityState();
	
	/**
	 * 状態を設定する。
	 *
	 * @param	actState	状態
	 */
	public void setActivityState(int actState);

	/**
	 * 実行者IDを取得する。
	 *
	 * @return	実行者ID
	 */
	public String getActorID();
	
	/**
	 * 実行者IDを設定する。
	 *
	 * @param	actorID	実行者ID
	 */
	public void setActorID(String actorID);

	/**
	 * 最新状態更新日時を取得する。
	 *
	 * @return	最新状態更新日時
	 */
	public Timestamp getUpdateDate();
	
	/**
	 * 最新状態更新日時を設定する。
	 *
	 * @param	updateDate	最新状態更新日時
	 */
	public void setUpdateDate(Timestamp updateDate);
}
