/* $Id: UniqueKeyGenerator.java,v 1.3 2007/11/05 09:50:54 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.util;

import java.sql.SQLException;
import java.text.DecimalFormat;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.SequencerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * ユニークキーを生成するジェネレータです。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 1.0
 */
public class UniqueKeyGenerator
{
	/** エンジンログ */
	private static Logger eLog = LogManager.getEngineLogger();
	
	/** 十進フォーマット */
	private static DecimalFormat longFormatter
		= new DecimalFormat("0000000000000");


	/**
	 * prefixで始まるIDを生成する。
	 * 
	 * @param prefix 前置文字列
	 * @return ID
	 */
	static synchronized public String generate(String prefix)
	throws WorkflowException
	{
		try {
			boolean exec = true;
			String s = null;
			while (exec) {
				try {
					WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
					SequencerDAO sequencer = daoFactory.getSequencerDAO();
					long seq = sequencer.next(prefix);
					s = longFormatter.format(seq);
					exec = false;
				} catch (SQLException ex) {
					int code = ex.getErrorCode();
					if (code == 1205) {
						/* retry */
					} else {
						throw ex;
					}
				}
			}
			return prefix + s;
		} catch (Exception ex) {
			// ユニークキー生成中にエラーが起こりました。
			String errMsg = StringManager.get("E0039");
			eLog.error(errMsg, ex);
			throw new WorkflowException(errMsg, ex);
		}
	}

	/**
	 * 数値IDを生成する。
	 * 
	 * @param prefix 前置文字列
	 * @return ID
	 */
	static synchronized public int generateForInt(String prefix)
	throws WorkflowException
	{
		try {
			boolean exec = true;
			int seq = 0;
			while (exec) {
				try {
					WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
					SequencerDAO sequencer = daoFactory.getSequencerDAO();
					seq = sequencer.nextForInt(prefix);
					exec = false;
				} catch (SQLException ex) {
					int code = ex.getErrorCode();
					if (code == 1205) {
						/* retry */
					} else {
						throw ex;
					}
				}
			}
			return seq;
		} catch (Exception ex) {
			// ユニークキー生成中にエラーが起こりました。
			String errMsg = StringManager.get("E0039");
			eLog.error(errMsg, ex);
			throw new WorkflowException(errMsg, ex);
		}
	}
}
