/* $Id: ScriptingToolAgentFactory.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgent;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory;

/**
 * スクリプト実行用ツールエージェントのためのファクトリークラスである。
 *
 * @author  kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ScriptingToolAgentFactory implements ToolAgentFactory {

    /** スクリプト実行用ツールエージェントのキュー名 */
    protected static final String QUEUE_NAME = "SCRIPTING";
    
    /* ログオブジェクト */
    private static Logger log = Logger.getLogger(ScriptingToolAgentFactory.class);

    /** ツールエージェント試行回数 */
    private int retryCount = 1;

    /* スクリプト実行用ツールエージェントのシングルトンインスタンス */
    private static AbstractToolAgent agent = null;
    
    static {
        init();
    }
    
    /**
     * ツールエージェントファクトリオブジェクトを生成する。
     *
     */
    public ScriptingToolAgentFactory() {
        // 処理なし。
    }
    
	/**
	 * スクリプト実行用ツールエージェントを返す。
	 *
	 * @return ツールエージェント
	 * @see jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory#getToolAgent()
	 */
	public ToolAgent getToolAgent() {
	    if (agent != null) {
	        agent.setRetryCount(this.retryCount);
	    }
	    
	    return agent;
	}

	/**
	 * 試行回数を設定する。
	 *
	 * @param count 試行回数
	 * @see jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory#setRetryCount(int)
	 */
	public void setRetryCount(int count) {
		int n = count;
		if (n < 1) n = 1;
		this.retryCount = n;
	}
	
	/**
	 * ファクトリクラスを初期化する。
	 * 
	 * システムコマンド実行用のキューを監視する
	 * マネージャを別スレッドで起動する。
	 */
	private synchronized static void init() {
	    
	    WorkflowEngine engine = null;
	    String session = null;
	    try {
		    // 設定情報を取得する
		    ScriptingConfig config = ScriptingConfigFactory.getConfig();
		    
		    engine = WorkflowEngine.getInstance();
		    session = engine.connect(config.getUser(), config.getPassword());
		    /* メッセージキューを作成する */
		    ScriptingMessageAdapter executor = new ScriptingMessageAdapter();
		    engine.generateQueue(session, QUEUE_NAME, executor);
		    
		    if (agent == null) {
		        agent = new ScriptingToolAgent(config.getUser(), config.getPassword());
		    }
	    } catch (Exception ex) {
	        // エラー処理
	        String errMsg = StringManager.get("E2006");
	        log.error(errMsg, ex);
	    } finally {
	        try {
	            if (session != null) {
	                engine.disconnect(session);
	            }
	        } catch (Exception ex) {
	            /* Ignore */
	        }
	    }
	}
}
