/* $Id: ScriptingExecutionInfo.java,v 1.3 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * スクリプト実行用ツールエージェントのアプリケーション実行情報クラス
 * 
 * @author kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since Nautica Workflow 1.0
 */
public class ScriptingExecutionInfo extends AppExecutionInfo
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** スクリプトに作業項目IDを渡す際のキー名 */
	public static final String NAUTICA_WID = "__NAUTICA_WID__";

	/** スクリプト実行用実行情報のメッセージタイプ */
	private static final int MESSAGE_TYPE = 803;

	/** スクリプトの引数格納用マップ */
	private Map<String, Object> parameters = new HashMap<String, Object>();

	/**
	 * 引数付コンストラクタ
	 * 
	 * @param appName
	 *            アプリケーション名
	 * @param toolAgent
	 *            ツールエージェントのクラス名
	 * @param wid
	 *            作業項目ID
	 * @param handler
	 *            ツールエージェントハンドラ（＝作業項目ID）
	 * @param attrList
	 *            引数リスト
	 */
	ScriptingExecutionInfo(String appName, String toolAgent, String wid,
			int handler, Attribute[] attrList)
	{
		super(MESSAGE_TYPE);
		this.setAppName(appName);
		this.setToolAgent(toolAgent);
		this.setWid(wid);
		this.setHandler(handler);
		this.setAttributes(attrList);
	}

	ScriptingExecutionInfo(HashMap<String, Serializable> map)
	{
		super(map);
		this.parse(getAttributes());
	}

	/**
	 * スクリプト実行のパラメータを取得する。
	 * 
	 * スクリプト実行のためのパラメータが格納されたMapオブジェクトが 返る。 パラメータがない場合は、空のMapオブジェクトが返る。
	 * 
	 * @return スクリプト実行のパラメータ
	 */
	public Map<String, Object> getParameters()
	{
		return this.parameters;
	}

	/**
	 * エンジンからのプロセス変数配列を解釈して、 スクリプト実行用パラメータを作成する。
	 * 
	 * @param attrList
	 *            プロセス変数配列
	 */
	private void parse(Attribute[] attrList)
	{

		if (attrList == null) {
			return;
		}
		// まずはキー単位で値をまとめる
		Map<String, List<String>> nameMap = new HashMap<String, List<String>>();
		for (int i = 0; i < attrList.length; i++) {
			String name = attrList[i].getName();
			List<String> valueList = nameMap.get(name);
			if (valueList == null) {
				valueList = new ArrayList<String>();
			}
			valueList.add(attrList[i].getValue());
			nameMap.put(attrList[i].getName(), valueList);
		}
		// パラメータの値の型を整理する
		for (String key : nameMap.keySet()) {
			List<String> valueList = nameMap.get(key);
			if (valueList.size() > 1) {
				String[] param = (String[]) valueList.toArray(new String[0]);
				parameters.put(key, param);
			} else {
				String param = (String) valueList.get(0);
				parameters.put(key, param);
			}
		}
	}
}
