/* $Id: ExecutionCounter.java,v 1.1 2007/11/28 07:09:06 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngineConstants;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * ツールエージェントの実行回数を管理するカウンタ。
 * ActiveMQのトランザクション管理とは独立して動作する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ExecutionCounter
{
	/** エンジンログ */
	private static Logger eLog = LogManager.getEngineLogger();
	
	private static final String COUNT_DATA = "execution.dat"; 

	private static final String path;
	
	private static Properties counter;

	static
	{
		String home = System.getProperty(WorkflowEngineConstants.NAUTICA_HOME);
		String separator = System.getProperty("file.separator");
		String tempDir = "temp";
		path = home + separator + tempDir + separator + COUNT_DATA;
		Reader reader = null;
		counter = new Properties();
		try {
			reader = new FileReader(path);
			counter.load(reader);
		} catch (IOException ex) {
			String msg = StringManager.get("W2001");
			eLog.warn(msg);
		} finally {
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException ex2) {
				}
			}
		}
	}
	
	/**
	 * 実行回数を返す。
	 *
	 * @param id ActiveMQメッセージID
	 * @return 実行回数。未設定の場合は-1
	 */
	public static synchronized int get(String id)
	{
		String s = counter.getProperty(id);
		if (s == null) return -1;
		
		return Integer.parseInt(s);
	}
	
	/**
	 * 実行回数を設定する。
	 *
	 * @param id ActiveMQメッセージID
	 * @param c 実行回数
	 */
	public static synchronized void set(String id, int c)
	{
		int n = c;
		if (n < 0) n = 0;
		counter.setProperty(id, "" + n);
		store();
	}
	
	/**
	 * 実行回数を1減らす。
	 *
	 * @param id ActiveMQメッセージID
	 * @return 減らせた場合はtrue, それ以外はfalse
	 */
	public static synchronized boolean update(String id)
	{
		int n = get(id);
		if (n <= 0) return false;
		n--;
		set(id, n);
		return true;
	}
	
	/**
	 * カウンターから外す。
	 *
	 * @param id ActiveMQメッセージID
	 */
	public static synchronized void clear(String id)
	{
		counter.remove(id);
	}
	
	private static void store()
	{
		Writer writer = null;
		try {
			writer = new FileWriter(path);
			counter.store(writer, "ToolAgent execution count data.");
		} catch (IOException ex) {
			String msg = StringManager.get("E2013");
			eLog.error(msg);
		} finally {
			if (writer != null) {
				try {
					writer.close();
				} catch (IOException ex2) {
				}
			}
		}
	}
}
