/* $Id: AppExecutionInfo.java,v 1.2 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.Serializable;
import java.util.HashMap;

import jp.co.argo21.nautica.workflow.jms.AbstractWorkflowMessage;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;

/**
 * アプリケーション実行情報クラス
 * 
 * @author kiyoda(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since Nautica Workflow 1.0
 */
public abstract class AppExecutionInfo extends AbstractWorkflowMessage
{
	/** アプリケーション名 */
	public static final String TA_APPLICATION_NAME = "___TA_APPLICATION_NAME___";

	/** 作業項目ID */
	public static final String TA_WORK_ITEM_ID = "___TA_WORK_ITEM_ID___";

	/** ツールエージェントのクラス名 */
	public static final String TA_CLASS_NAME = "___TA_CLASS_NAME___";

	/** ツールエージェントハンドラ */
	public static final String TA_HANDLER = "___TA_HANDLER___";

	/** 属性一覧 */
	public static final String TA_ATTRIBUTES_COUNT = "___TA_ATTRIBUTES_COUNT___";
	public static final String TA_ATTRIBUTE_TYPE = "___TA_ATTRIBUTE_TYPE___/";
	public static final String TA_ATTRIBUTE_NAME = "___TA_ATTRIBUTE_NAME___/";
	public static final String TA_ATTRIBUTE_VALUE = "___TA_ATTRIBUTE_VALUE___/";

	/** ツールエージェント試行回数 */
	public static final String TA_RETRY_COUNT = "___TA_RETRY_COUNT___";

	/**
	 * アプリケーション実行情報オブジェクトを生成する。
	 * 
	 */
	public AppExecutionInfo(int t)
	{
		super(t);
	}

	public AppExecutionInfo(HashMap<String, Serializable> map)
	{
		super(map);
	}

	/**
	 * アプリケーション名を返す。
	 * 
	 * @return アプリケーション名
	 */
	public String getAppName()
	{
		return (String)getValue(TA_APPLICATION_NAME);
	}

	/**
	 * アプリケーション名を設定する。
	 * 
	 * @param appName
	 *            アプリケーション名
	 */
	public void setAppName(String appName)
	{
		putValue(TA_APPLICATION_NAME, appName);
	}

	/**
	 * ツールエージェントのクラス名を返す。
	 * 
	 * @return ツールエージェントのクラス名
	 */
	public String getToolAgent()
	{
		return (String)getValue(TA_CLASS_NAME);
	}

	/**
	 * ツールエージェントのクラス名を設定する。
	 * 
	 * @param toolAgent
	 *            ツールエージェントのクラス名
	 */
	public void setToolAgent(String toolAgent)
	{
		putValue(TA_CLASS_NAME, toolAgent);
	}

	/**
	 * ツールエージェントハンドラを返す。
	 * 
	 * @return ツールエージェントハンドラ
	 */
	public int getHandler()
	{
		return (Integer)getValue(TA_HANDLER);
	}

	/**
	 * ツールエージェントハンドラを設定する。
	 * 
	 * @param handler
	 *            ツールエージェントハンドラ
	 */
	public void setHandler(int handler)
	{
		putValue(TA_HANDLER, handler);
	}

	/**
	 * 属性一覧を返す。
	 * 
	 * @return 属性一覧
	 */
	public Attribute[] getAttributes()
	{
		int count = 0;
		Integer o = (Integer)getValue(TA_ATTRIBUTES_COUNT);
		if (o != null) { count = o.intValue(); }
		Attribute[] attributes = new Attribute[count];

		for (int i = 0; i < count; i++) {
			int type = (Integer)getValue(TA_ATTRIBUTE_TYPE + i);
			String name = (String)getValue(TA_ATTRIBUTE_NAME + i);
			String value = (String)getValue(TA_ATTRIBUTE_VALUE + i);
			Attribute a = new AttributeDelegate(type, name, value);
			attributes[i] = a;
		}

		return attributes;
	}

	/**
	 * 属性一覧を設定する。
	 * 
	 * @param attrList
	 *            属性一覧
	 */
	public void setAttributes(Attribute[] attrList)
	{
		if (attrList == null) {
			putValue(TA_ATTRIBUTES_COUNT, 0);
		} else {
			int size = attrList.length;
			int count = 0;
			for (int i = 0; i < size; i++) {
				Attribute a = attrList[i];
				if (a != null) {
					putValue(TA_ATTRIBUTE_TYPE + i, a.getType());
					putValue(TA_ATTRIBUTE_NAME + i, a.getName());
					putValue(TA_ATTRIBUTE_VALUE + i, a.getValue());
					count++;
				}
			}
			putValue(TA_ATTRIBUTES_COUNT, count);
		}
	}

	/**
	 * 作業項目IDを返す。
	 * 
	 * @return 作業項目ID
	 */
	public String getWid()
	{
		return (String)getValue(TA_WORK_ITEM_ID);
	}

	/**
	 * 作業項目IDを設定する。
	 * 
	 * @param wid
	 *            作業項目ID
	 */
	public void setWid(String wid)
	{
		putValue(TA_WORK_ITEM_ID, wid);
	}

	/**
	 * 試行回数を取得する。
	 * 
	 * @return 試行回数
	 */
	public int getRetryCount()
	{
		return (Integer)getValue(TA_RETRY_COUNT);
	}

	/**
	 * 試行回数を設定する。
	 * 
	 * @param count
	 *            試行回数
	 */
	public void setRetryCount(int count)
	{
		putValue(TA_RETRY_COUNT, count);
	}

	/**
	 * オブジェクトの文字列表現を返します。
	 * 
	 * @return このオブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		StringBuffer buf = new StringBuffer();

		buf.append("ApplicationName=")
		   .append(getAppName()).append(", ")
		   .append("WorkItemID=")
		   .append(getWid()).append(", ")
		   .append("ToolAgentClassName=")
		   .append(getToolAgent()).append(", ")
		   .append("ToolAgentHandler=")
		   .append(getHandler()).append(", ")
		   .append("Attributes=")
		   .append(getAttributes()).append(", ")
		   .append("RetryCount=")
		   .append(getRetryCount());

		return buf.toString();
	}
}
