/* $Id: SessionManager.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security;

import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * セッション管理を行う。
 * 実際には、任意のセッション管理システムを利用するために、
 * このインタフェースを利用した具体実装を用意しなければならない。
 * 本ワークフローシステム運用基盤では、
 * 参考実装としてSimpleSessionManagerを提供する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface SessionManager
{
	/**
	 * 引数のユーザIDとパスワードを用いて、認証を行う。
	 * 戻り値として、対応付けたセッションIDを返す。
	 *
	 * @param uid ユーザID
	 * @param password パスワード
	 * @return セッションID
	 * @throws ConnectionFailedException 接続認証に失敗した場合
	 */
	public String createSession(String uid, String password)
	throws ConnectionFailedException;

	/**
	 * 引数として渡されたセッションIDを検証する。
	 * セッションIDに対応するセッション情報があれば、
	 * 最終アクセス時間を更新する。
	 * 戻り値として、対応付けたセッションIDを返す。
	 * 対応するセッション情報がなければ、例外を返す。
	 * ここで新規にロールが割り当てられることはない。
	 * セッションIDが有効でない場合は、例外とする。
	 *
	 * @param session セッションID
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public void validateSession(String session)
	throws InvalidSessionException;
	
	/**
	 * 引数に渡されたセッションIDと、それに対応するセッション情報を無効にする。
	 * セッションIDが有効でない場合は、例外とする。
	 *
	 * @param session セッションID
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public void invalidateSession(String session)
	throws InvalidSessionException;
	
	/**
	 * 引数に渡されたセッションIDに結び付けられている、Userオブジェクトを返す。
	 *
	 * @param session セッションID
	 * @return セッションIDに結び付けられているUser
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 */
	public User getSessionUser(String session)
	throws InvalidSessionException;
}
