/* $Id: Session.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.security;

import java.util.Date;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * ワークフローシステム運用基盤におけるセッション情報。
 * 任意のセッション管理に対応するため、
 * 既存のセッション情報をラップする形で提供される。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Session {

	/**
	 * セッション情報のID
	 *
	 * @return セッションID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getID() throws WorkflowException;

	/**
	 * このセッションに割り付けられたユーザ情報
	 *
	 * @return ユーザ
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public User getUser() throws WorkflowException;

	/**
	 * このセッション情報の生成時間
	 *
	 * @return セッション情報の生成時間
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public Date getCreatedTime() throws WorkflowException;

	/**
	 * このセッション情報への最後のアクセス時間
	 *
	 * @return 最後のアクセス時間
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public Date getLastAccessedTime() throws WorkflowException;
}
