/* $Id: WfResource.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfResourceは、アクティビティに割り当てられる
 * 人や物を表す管理実体を表す基底インタフェースである。
 * 本書では、この管理実体を「リソース」と表記する。
 * WfResourceは、WfAssignmentによってWfActivityと関連付けられる。
 * WfResourceを実装するクラスとして考えられるのは、
 * 人や物を表すオブジェクトに対するアダプタなどである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WfResource extends WfObject {

	/**
	 * IDを返す。
	 *
	 * @return ID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getID() throws WorkflowException;

	/**
	 * 名称を返す
	 *
	 * @return 名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getName() throws WorkflowException;

	/**
	 * リソースに関連付けられたアサインメントの個数を返す。
	 *
	 * @return 名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getWorkItemCount() throws WorkflowException;

	/**
	 * IDで指定されたアサインメントを返す。
	 *
	 * @param wid ID
	 * @return アサインメント
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfAssignment getWorkItem(String wid) throws WorkflowException;

	/**
	 * リソースに関連付けられたすべてのアサインメントを返す。
	 *
	 * @return アサインメントの一覧
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfAssignment[] getAllWorkItem() throws WorkflowException;

	/**
	 * 引数で指定されたアサインメントと、関連を持つかどうかを返す。
	 *
	 * @param ass アサインメント
	 * @return 関連を持つ場合はtrue
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public boolean isMemberOfWorkItems(WfAssignment ass)
	throws WorkflowException;

	/**
	 * 引数に指定したアサインメントにとって、
	 * リソースが不要になったことを通知するリスナーインタフェース。
	 * 引数として、もうリソースに関連付けられていないアサインメントと、
	 * リソースを解放する理由をとる。
	 * このインタフェースは、アサインメントが削除された場合や、
	 * アサインメントが他のリソースへ再割り当てされた場合に
	 * 内部的に呼び出されることを想定している。
	 *
	 * @param ass アサインメント
	 * @param info 開放する理由
	 * @throws NotAssignedException アサインメントが関連していない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void release(WfAssignment ass, String info)
	throws NotAssignedException, WorkflowException;
}
