/* $Id: WfRequester.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfRequesterは、プロセスの実行や結果取得を行う管理実体を表す基底インタフェースである。
 * 本書では、この管理実体を「プロセス要求者」と表記する。
 * プロセス要求者によって要求されたプロセスは、重要な状態変化をプロセス要求者に
 * 伝えるものとする。1つのプロセス要求者は、複数のプロセスを要求し、
 * 管理することも想定しなければならない。
 * WfRequesterを実装するクラスとして考えられるのは、ひとつはアクティビティである。
 * サブプロセスを要求するアクティビティは、このインタフェースを実装する必要がある。
 * もうひとつは、クライアントからのプロセス生成を可能にするための、アダプターが考えられる。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WfRequester extends WfObject {

	/**
	 * 管理しているプロセスの個数を返す。
	 *
	 * @return プロセスの個数
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getPerformerCount() throws WorkflowException;

	/**
	 * インデクスで指定されたプロセスを返す。
	 *
	 * @param index インデクス
	 * @return プロセス
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfProcess getPerformer(int index) throws WorkflowException;

	/**
	 * 管理下のすべてのプロセスを返す。
	 *
	 * @return プロセス
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfProcess[] getAllPerformers() throws WorkflowException;

	/**
	 * 引数で指定されたプロセスが、管理下にあるかどうかを返す。
	 *
	 * @param proc プロセス
	 * @return 管理下にある場合はtrue
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public boolean isMemberOfPerformer(WfProcess proc)
	throws WorkflowException;

	/**
	 * WfProcessがそのリクエスタにワークフローイベントを通知するために
	 * 使用されるリスナーインタフェース。このインタフェースを通して、
	 * WfProcessは、完了(complete)、停止(terminate)、中断(abort)のイベントや、
	 * クローズド(closed)状態への遷移をリクエスタに通知するものとする。
	 *
	 * @param event イベント
	 * @throws InvalidPerformerException 無効なプロセスの場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void receiveEvent(WfEvent event)
	throws InvalidPerformerException, WorkflowException;

	/**
	 * リクエスタに関連するリソースを返す。
	 *
	 * @return リクエスタの主体となったリソース
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfResource getReqesterResource() throws WorkflowException;
}
