/* $Id: WfEvent.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfEventは、ワークフロー遂行中に発生するイベントの管理実体を表すインタフェースである。
 * OMG仕様ではWfEventAuditとしているが、WfEventとした。
 * 本書では、この管理実体を「ワークフロー監査情報」と表記する。
 * WfEventは、すべての種類のワークフロー監査情報の基底インタフェースを提供する。
 * イベントの種類には、状態の変化、リソース割り当ての変更、データの変更などがある。
 * また、ワークフロー監査情報はワークフローの変更履歴としての側面を持ち、
 * 永続化されている必要がある。
 * この変更履歴は、WfExecutionObjectのgetHistory()操作によってアクセス可能とする。
 * WfEventオブジェクトは、ワークフローがその状態を変化させる時に生成されるが、
 * その存続期間はイベントを引き起こしたオブジェクトの存続期間とは独立して管理される。
 * それらは、別途運用管理にて定めるものとする。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WfEvent extends WfObject {

	/**
	 * イベントの種類を返す。
	 *
	 * @return イベントの種類
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getEventType() throws WorkflowException;

	/**
	 * イベントを引き起こしたWfExecutionObjectを返す。
	 *
	 * @return WfExecutionObject
	 * @throws SourceNotAvailableException ソースがない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfExecutionObject getSource()
	throws SourceNotAvailableException, WorkflowException;

	/**
	 * イベントが発生した日時を返す。
	 *
	 * @return イベント発生日時
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getTimestamp() throws WorkflowException;

	/**
	 * イベントに関連するプロセスマネージャの名称を返す。
	 *
	 * @return プロセスマネージャの名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getProcessManagerName() throws WorkflowException;

	/**
	 * イベントに関連するプロセスマネージャのバージョンを返す。
	 *
	 * @return プロセスマネージャのバージョン
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getProcessManagerVersion() throws WorkflowException;

	/**
	 * イベントに関連するプロセスIDを返す。
	 *
	 * @return プロセスID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getProcessID() throws WorkflowException;

	/**
	 * イベントに関連するプロセス名称を返す。
	 *
	 * @return プロセス名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getProcessName() throws WorkflowException;

	/**
	 * イベントに関連するアクティビティIDを返す。
	 *
	 * @return アクティビティID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getActivityID() throws WorkflowException;

	/**
	 * イベントに関連するアクティビティ名称を返す。
	 *
	 * @return アクティビティ名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getActivityName() throws WorkflowException;
}
