/* $Id: WfAssignment.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfAssignmentは、WfActivityオブジェクトをWfResourceオブジェクトに
 * 結合させる管理実体を表すインタフェースである。
 * 本書では、この管理実体を「アサインメント」と表記する。
 * アサインメントは、リソース管理機能によって管理されることを想定しており、
 * アクティビティとリソースを使用して適切にアサインメントを生成・管理する。
 * WfAssignmentは、アクティビティの実行準備を整える段階で、
 * リソース選択過程の一部として生成される。
 * WfAssignmentの存続期間は、関連付けられたアクティビティの存続期間によって制限される。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WfAssignment extends WfObject {

	/**
	 * リソースを割り当てるアクティビティを返す。
	 *
	 * @return WfActivity
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfActivity getActivity() throws WorkflowException;

	/**
	 * 割り当てられたリソースを返す。
	 *
	 * @return WfResource
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfResource getAssignee() throws WorkflowException;

	/**
	 * 指定されたリソースを設定する。
	 *
	 * @param value WfResource
	 * @throws InvalidResourceException 無効なリソースの場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void setAssignee(WfResource value)
	throws InvalidResourceException, WorkflowException;
}
