/* $Id: WfActivity.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.omg;

/**
 * WfActivityはビジネスプロセスにおける1つの作業要求ステップの
 * 管理実体を表すインタフェースである。
 * 本書では、この管理実体を「アクティビティ」と表記する。
 * WfActivityは、１つのWfProcessに関連付けられている。
 * 任意の時点において、WfProcess内では複数のWfActivityオブジェクトが
 * 活性化されている場合がある。
 * WfActivityは、アクティビティに対する明示的な完了操作と
 * 作業結果を設定する操作、WfProcessやWfAssignmentとの関連を追加することで、
 * WfExecutionObjectを特化している。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WfActivity extends WfExecutionObject, WfRequester {

	/**
	 * このアクティビティが所属しているWfProcessを返す。
	 *
	 * @return WfProcess
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfProcess getContainer() throws WorkflowException;

	/**
	 * 割り当てられているアサインメントの個数を返す。
	 *
	 * @return WfAssignmentの個数
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getAssignmentCount() throws WorkflowException;

	/**
	 * インデクスで指定されたアサインメントを返す。
	 *
	 * @param index インデクス
	 * @return WfAssignment
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfAssignment getAssignment(int index) throws WorkflowException;

	/**
	 * 割り当てられているすべてのアサインメントを返す。
	 *
	 * @return WfAssignment
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfAssignment[] getAllAssignment() throws WorkflowException;

	/**
	 * 指定されたアサインメントが、このアクティビティに割り当てられたものかどうかを返す。
	 *
	 * @param ass WfAssignment
	 * @return このアクティビティに割り当てられたものである場合はtrue
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public boolean isMemberOfAssignment(WfAssignment ass) throws WorkflowException;

	/**
	 * WfActivityの完了を要求するために、アプリケーションによって使用される。
	 * これは、setResult()と共に、アクティビティの結果をプロセスに返すために使用される。
	 *
	 * @throws CannotCompleteException 完了できない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void complete()
	throws CannotCompleteException, WorkflowException;

	/**
	 * WfActivityによって表される作業の実行によって生成される結果を返す。
	 * 結果データがまだ利用可能でない場合は、例外が発生する。
	 *
	 * @return　実行結果を返す
	 * @throws ResultNotAvailableException 結果がない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfNameValue[] getResult()
	throws ResultNotAvailableException, WorkflowException;

	/**
	 * WfActivityによって表される作業の実行によって生成される結果を設定する。
	 *
	 * @param result 実行結果を設定する。
	 * @throws InvalidDataException 無効なデータの場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void setResult(WfNameValue[] result)
	throws InvalidDataException, WorkflowException;
}
