/* $Id: AbstractWorkflowMessage.java,v 1.1 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.jms;

import java.io.Serializable;
import java.util.HashMap;

public abstract class AbstractWorkflowMessage implements WorkflowMessage
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20070000000000001L;

	/** メッセージの種類 */
	public static final String WF_MESSAGE_TYPE = "__WORKFLOW_MESSAGE_TYPE__";

	private HashMap<String, Serializable> map = new HashMap<String, Serializable>();

	public AbstractWorkflowMessage(int t)
	{
		super();

		putValue(WF_MESSAGE_TYPE, t);
	}

	public AbstractWorkflowMessage(HashMap<String, Serializable> map)
	{
		super();

		if (map != null) {
			this.map = map;
		}
	}

	/**
	 * メッセージの種類を表す数値を返す。
	 * 1-1000までは、本ワークフロー運用基盤でリザーブするものとする。
	 *
	 * @return メッセージの種類
	 * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessage#getMessageType()
	 */
	@Override
	public int getMessageType()
	{
		return (Integer)getValue(WF_MESSAGE_TYPE);
	}

	@Override
	public HashMap<String, Serializable> getMessageMap()
	{
		return map;
	}
	
	protected Serializable getValue(String key)
	{
		return this.map.get(key);
	}
	
	protected void putValue(String key, Serializable value)
	{
		this.map.put(key, value);
	}
}
