/* $Id: NameFilter.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.filter;

import jp.co.argo21.nautica.workflow.wfmc.Filter;

/**
 * 名前によるフィルタリングを行う。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class NameFilter implements Filter
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** フィルタータイプ */
	private static int FILTER_TYPE = 5001;

	/** 演算子 */
	private int comparison;
	
	/** 比較名称 */
	private String value;
	
	/**
	 * 名前フィルターを生成する。
	 *
	 * @param value 名称
	 * @param comparison 演算子
	 */
	public NameFilter(String value, int comparison)
	{
		this.value = value;

		switch (comparison) {
			case NameFilter.EQUAL:
			case NameFilter.NOT_EQUAL:
			case NameFilter.LIKE:
				this.comparison = comparison;
				break;
			default:
				this.comparison = NameFilter.NOT_EQUAL;
		}
	}
	
	/**
	 * 演算子を返す。
	 *
	 * @return 演算子
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getComparison()
	 */
	public int getComparison()
	{
		return comparison;
	}

	/**
	 * フィルター名として、クラス名が返るが、使用されない。
	 *
	 * @return フィルター名
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterName()
	 */
	public String getFilterName()
	{
		return NameFilter.class.getName();
	}

	/**
	 * フィルター文字列として名称を返す。
	 *
	 * @return フィルター文字列
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getFilterString()
	 */
	public String getFilterString()
	{
		return value;
	}

	/**
	 * フィルタータイプを返す。
	 *
	 * @return フィルタータイプ
	 * @see jp.co.argo21.nautica.workflow.wfmc.Filter#getType()
	 */
	public int getType()
	{
		return NameFilter.FILTER_TYPE;
	}
}
