/* $Id: WorkflowEventObject.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.SourceNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfExecutionObject;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * ワークフローイベントを表す。このクラスは、互換性のために用意されているだけで
 * 現在のエンジンでは使われていない。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class WorkflowEventObject implements WfEvent
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** イベントの種類 */
	private String type;
	
	/**イベントを引き起こしたWfExecutionObject */
	private WfExecutionObject source;
	
	/** イベント発生日時 */
	private String timestamp;
	
	/** プロセスマネージャ名 */
	private String processManagerName;
	
	/** プロセスマネージャのバージョン */
	private String processManagerVersion;
	
	/** プロセスID */
	private String processID;
	
	/** プロセス名 */
	private String processName;
	
	/** アクティビティID */
	private String activityID;
	
	/** アクティビティ名 */
	private String activityName;

	/**
	 * ワークフローイベントを生成する。
	 *
	 * @param type イベントの種類
	 * @param source イベントを引き起こしたWfExecutionObject
	 * @param timestamp イベント発生日時
	 * @param processManagerName プロセスマネージャ名
	 * @param processManagerVersion プロセスマネージャのバージョン
	 * @param processID プロセスID
	 * @param processName プロセス名
	 * @param activityID アクティビティID
	 * @param activityName アクティビティ名
	 */
	public WorkflowEventObject(String type, WfExecutionObject source,
			String timestamp, String processManagerName,
			String processManagerVersion, String processID, String processName,
			String activityID, String activityName)
	{
		this.type = type;
		this.source = source;
		this.timestamp = timestamp;
		this.processManagerName = processManagerName;
		this.processManagerVersion = processManagerVersion;
		this.processID = processID;
		this.processName = processName;
		this.activityID = activityID;
		this.activityName = activityName;
	}

	/**
	 * イベントの種類を返す。
	 *
	 * @return イベントの種類
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getEventType()
	 */
	public String getEventType() throws WorkflowException
	{
		return type;
	}

	/**
	 * イベントを引き起こしたWfExecutionObjectを返す。
	 *
	 * @return WfExecutionObject
	 * @throws SourceNotAvailableException ソースがない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getSource()
	 */
	public WfExecutionObject getSource()
	throws SourceNotAvailableException, WorkflowException
	{
		return source;
	}

	/**
	 * イベントが発生した日時を返す。
	 *
	 * @return イベント発生日時
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getTimestamp()
	 */
	public String getTimestamp() throws WorkflowException
	{
		return timestamp;
	}

	/**
	 * イベントに関連するプロセスマネージャの名称を返す。
	 *
	 * @return プロセスマネージャの名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessManagerName()
	 */
	public String getProcessManagerName() throws WorkflowException
	{
		return processManagerName;
	}

	/**
	 * イベントに関連するプロセスマネージャのバージョンを返す。
	 *
	 * @return プロセスマネージャのバージョン
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessManagerVersion()
	 */
	public String getProcessManagerVersion() throws WorkflowException
	{
		return processManagerVersion;
	}

	/**
	 * イベントに関連するプロセスIDを返す。
	 *
	 * @return プロセスID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessID()
	 */
	public String getProcessID() throws WorkflowException
	{
		return processID;
	}

	/**
	 * イベントに関連するプロセス名称を返す。
	 *
	 * @return プロセス名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getProcessName()
	 */
	public String getProcessName() throws WorkflowException
	{
		return processName;
	}

	/**
	 * イベントに関連するアクティビティIDを返す。
	 *
	 * @return アクティビティID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getActivityID()
	 */
	public String getActivityID() throws WorkflowException
	{
		return activityID;
	}

	/**
	 * イベントに関連するアクティビティ名称を返す。
	 *
	 * @return アクティビティ名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfEvent#getActivityName()
	 */
	public String getActivityName() throws WorkflowException
	{
		return activityName;
	}
}
