/* $Id: WorkflowEngineService.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2007.  All rights reserved.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

public interface WorkflowEngineService
{
	/**
	 * 指定された名前で、メッセージキューを作成する。
	 *
	 * @param session セッションID
	 * @param queueName キュー名
	 * @param adapter メッセージ受信用のアダプタ
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws WorkflowException キューが既にある場合などは例外となる。
	 */
	public void generateQueue(String session, String queueName,
			WorkflowMessageAdapter adapter)
	throws InvalidSessionException, WorkflowException;

	/**
	 * メッセージ転送を返す。
	 *
	 * @param session セッションID
	 * @param queueName キュー名
	 * @return メッセージ転送
	 * @throws InvalidSessionException 指定されたセッションが無効の場合
	 * @throws MessagingException キューが存在しない場合
	 */
	public MessageTransporter getMessageTransporter(String session, String queueName)
	throws InvalidSessionException, MessagingException;

	public InterWorkflowConnector getInterWorkflowConnector(); 
}
