/* $Id: WorkflowEngineConstants.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

/**
 * ワークフローエンジン関係の定数を定義する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkflowEngineConstants
{
	/** ワークフローエンジンホーム */
	public static final String NAUTICA_HOME = "nautica.home";

	/** 管理者キー */
	static final String NAUTICA_ADMIN = "nautica.workflow.admin";

	/** スコープ */
	static final String NAUTICA_SCOPE = "nautica.workflow.scope";

	/** エンジン間接続利用の有無 */
	static final String NAUTICA_INTER_WORKFLOW = "nautica.workflow.interworkflow";

	/** メッセージキュー設定ファイル */
	static final String NAUTICA_MQ_CONFIG = "nautica.workflow.mq.config";

	/** ロギング設定ファイル */
	static final String NAUTICA_LOGGING_CONFIG = "nautica.workflow.logging.config";

	/** 利用セッションマネージャ */
	static final String NAUTICA_SESSION_MANAGER = "nautica.workflow.sessionManager";

	/** 利用ユーザマネージャ */
	static final String NAUTICA_USER_MANAGER = "nautica.workflow.userManager";

	/** 利用組織マネージャ */
	static final String NAUTICA_ORG_MANAGER = "nautica.workflow.organizationManager";

	/** 利用権限マネージャ */
	static final String NAUTICA_ROLE_MANAGER = "nautica.workflow.roleManager";

	/** DAOファクトリ */
	static final String NAUTICA_DAO_FACTORY = "nautica.workflow.dao.factory";

	/** 最大定義キャッシュ数 */
	static final String NAUTICA_REPOSITORY_MAX_CACHE_COUNT = "nautica.workflow.repository.maxCacheCount";

	/** プレロード定義パス名 */
	static final String NAUTICA_REPOSITORY_PRELOAD_PATH = "nautica.workflow.repository.preloadPath";
}
