/* $Id: StartProcessRequestMessage.java,v 1.2 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.Serializable;
import java.util.HashMap;

/**
 * プロセス開始要求メッセージを表す。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class StartProcessRequestMessage extends RequestMessage
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** メッセージの種類番号 */
	public static final int MESSAGE_TYPE = 102;

	/** エンジンID */
	public static final String WF_ENGINE_ID = "___WORKFLOW_ENGINE_ID___";

	/** プロセスID */
	public static final String WF_PROCESS_ID = "___WORKFLOW_PROCESS_ID___";

	/**
	 * プロセス開始要求メッセージを生成する。
	 *
	 * @param eid エンジンID
	 * @param pid プロセスID
	 */
	public StartProcessRequestMessage(String eid, String pid)
	{
		super(MESSAGE_TYPE);
		
		putValue(WF_ENGINE_ID, eid);
		putValue(WF_PROCESS_ID, pid);
	}

	/**
	 * プロセス開始要求メッセージを生成する。
	 *
	 * @param pid プロセスID
	 */
	public StartProcessRequestMessage(String pid)
	{
		super(MESSAGE_TYPE);
		
		putValue(WF_PROCESS_ID, pid);
	}

	public StartProcessRequestMessage(HashMap<String, Serializable> map)
	{
		super(map);
	}

	/**
	 * エンジンIDを返す。
	 *
	 * @return エンジンID
	 */
	public String getEngineID()
	{
		return (String)getValue(WF_ENGINE_ID);
	}

	/**
	 * プロセスIDを返す。
	 *
	 * @return プロセスID
	 */
	public String getProcessID()
	{
		return (String)getValue(WF_PROCESS_ID);
	}
}
