/* $Id: StartActivityRequestWatcher.java,v 1.4 2007/11/28 07:09:06 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.Serializable;
import java.util.HashMap;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * アクティビティ開始要求キューを監視する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 1.0
 */
class StartActivityRequestWatcher extends WorkflowMessageAdapter
{
	/** エンジンログ */
	private static Logger eLog = LogManager.getEngineLogger();
	/** メッセージキュー名 */
	public static final String NAME = "START_ACTIVITY_REQUEST";
	
	/**
	 * アクティビティ開始要求キュー監視を生成する。
	 */
	StartActivityRequestWatcher()
	{
	}

	@Override
	protected WorkflowMessage getMessage(HashMap<String, Serializable> map)
	{
		return new StartActivityRequestMessage(map);
	}

	/**
	 * アクティビティ開始要求を処理する。
	 *
	 * @param mid メッセージID
	 * @param message メッセージ
	 * @param isRedelivered 再配信フラグ
	 * @see jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter#onMessage(java.lang.String, jp.co.argo21.nautica.workflow.jms.WorkflowMessage, boolean)
	 */
	public void onMessage(String mid, WorkflowMessage message, boolean isRedelivered)
	{
		if (message instanceof StartActivityRequestMessage == false) {
			//ログに出力して無視
			// 不正なメッセージ形式です。
			String E0099 = StringManager.get("E0099");
			eLog.error(E0099);
			return;
		}
		StartActivityRequestMessage msg = (StartActivityRequestMessage)message;
		String pid = msg.getProcessID();
		String aid = msg.getActivityID();

		ActivityInternal act = null;
		try {
			DataAccessManager.begin(false);
			
			ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
			ProcessManager pm = pmf.getOwnerProcessManager(pid);
			ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
			act = (ActivityInternal)proc.getStep(aid);
			
			act.start();

		} catch (Exception ex) {
			try {
				String E0102 = StringManager.get("E0102");
				eLog.error(E0102, ex);

				//アクティビティ異常終了を試みる。
				act.terminate(false);
			} catch (Exception ex2) {
				String F0102 = StringManager.get("F0102");
				eLog.fatal(F0102, ex);
			}
		} finally {
			try { DataAccessManager.commit(); } catch (Exception ex) { /* Ignore */ }
			try { DataAccessManager.close(); } catch (Exception ex) { /* Ignore */ }
		}
	}
}
