/* $Id: StartActivityRequestMessage.java,v 1.2 2007/11/13 06:58:25 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.Serializable;
import java.util.HashMap;

/**
 * アクティビティ開始要求メッセージを表す。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class StartActivityRequestMessage extends RequestMessage
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** メッセージの種類番号 */
	public static final int MESSAGE_TYPE = 101;

	/** プロセスID */
	public static final String WF_PROCESS_ID = "___WORKFLOW_PROCESS_ID___";

	/** アクティビティID */
	public static final String WF_ACTIVITY_ID = "___WORKFLOW_ACTIVITY_ID___";

	/**
	 * アクティビティ開始要求メッセージを生成する。
	 *
	 * @param pid プロセスID
	 * @param aid アクティビティID
	 */
	public StartActivityRequestMessage(String pid, String aid)
	{
		super(MESSAGE_TYPE);
		
		putValue(WF_PROCESS_ID, pid);
		putValue(WF_ACTIVITY_ID, aid);
	}

	public StartActivityRequestMessage(HashMap<String, Serializable> map)
	{
		super(map);
	}

	/**
	 * プロセスIDを返す。
	 *
	 * @return プロセスID
	 */
	public String getProcessID()
	{
		return (String)getValue(WF_PROCESS_ID);
	}

	/**
	 * アクティビティIDを返す。
	 *
	 * @return アクティビティID
	 */
	public String getActivityID()
	{
		return (String)getValue(WF_ACTIVITY_ID);
	}
}
