/* $Id: SessionManagerFactory.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * セッション管理を生成するファクトリークラスである。
 * 任意のセッション管理システムを利用するために、
 * このクラスを利用してセッションマネージャの具体実装を取得しなければならない。
 * エンジンで使用するセッションマネージャは、
 * プロパティNautica.sessionManagerに指定されたクラスを使用する。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class SessionManagerFactory
{
	/** エンジンログ */
	private static Logger eLog = LogManager.getEngineLogger();
	/** セキュリティログ */
	private static Logger sLog = LogManager.getSercurityLogger();
	
	/** SessionManagerFactoryのシングルトン */
	private static SessionManagerFactory singleton;

	/** セッション管理 */
	private SessionManager sessionManager;
	
	/**
	 * SessionManagerFactoryの生成と初期化を行う。
	 *
	 * @throws Exception 任意の例外
	 */
	static void create() throws Exception
	{
		singleton = new SessionManagerFactory();
		try {
			singleton.init();
		} catch (Exception ex) {
			eLog.error(StringManager.get("E1006"));
			throw ex;
		}
	}

	/**
	 * SessionManagerFactoryのインスタンスを返す。
	 *
	 * @return SessionManagerFactory
	 */
	static SessionManagerFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * SessionManagerFactoryを生成する。
	 */
	private SessionManagerFactory()
	{
	}
	
	/**
	 * SessionManagerFactoryを初期化する。
	 *
	 * @throws Exception 任意の例外
	 */
	private void init() throws Exception
	{
		String value = SystemChecker.getProperty(WorkflowEngineConstants.NAUTICA_SESSION_MANAGER);
		if (value == null || value.trim().equals("")) {
			String E1001 = StringManager.get("E1001");
			sLog.error(E1001);
			throw new WorkflowException(E1001);
		}
		sessionManager = (SessionManager)Class.forName(value).newInstance();
		String I1001 = StringManager.get("I1001");
		eLog.info(I1001);
	}

	/**
	 * セッションマネージャを返す。
	 *
	 * @return セッションマネージャ
	 */
	public SessionManager getSessionManager()
	{
		return sessionManager;
	}
}
