/* $Id: RepositoryLoader.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * RepositoryLoader は、XPDL ファイルを読み込む。
 *  
 * @author  mmamanbe(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface RepositoryLoader {
    
    /**
     * 指定されたパスの定義ファイルを文字列で返す。
     * なければ null を返す。
     * 何らかの例外が発生した場合も null を返す。
     * 
     * @param sid      セッションID
     * @param password 管理用パスワード
     * @param path     パス名
     * @return 定義ファイルの文字列
     */
    public String getDefinition(String sid, String password, String path)
    throws InvalidSessionException;
    
    /**
     * 指定されたプロセス定義名に対応するパス名を返す。
     * なければ null を返す。
     * 何らかの例外が発生した場合も null を返す。
     * 
     * @param sid    セッションID
     * @param pdname プロセス定義名
     * @return パス名
     */
    public String getDefinitionPath(String sid, String pdname)
    throws InvalidSessionException;
}
