/* $Id: ProcDefImpl.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;

/**
 * プロセス定義情報を表す。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ProcDefImpl implements ProcDef
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** プロセス定義ID */
	private String id;
	/** プロセス定義名 */
	private String name;
	/** 備考 */
	private String desc;
	/** プロセス定義状態 */
	private ProcessDefinitionState state;

	/**
	 * プロセス定義情報を生成する。
	 */
	ProcDefImpl()
	{
	}

	/**
	 * プロセス定義IDを返す。
	 *
	 * @return プロセス定義ID
	 * @see jp.co.argo21.nautica.workflow.wfmc.ProcDef#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * プロセス定義名を返す。
	 *
	 * @return プロセス定義名
	 * @see jp.co.argo21.nautica.workflow.wfmc.ProcDef#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * 備考を返す。
	 *
	 * @return 備考
	 * @see jp.co.argo21.nautica.workflow.wfmc.ProcDef#getDescription()
	 */
	public String getDescription()
	{
		return desc;
	}

	/**
	 * プロセス定義状態を返す。
	 *
	 * @return プロセス定義状態
	 * @see jp.co.argo21.nautica.workflow.wfmc.ProcDef#getState()
	 */
	public ProcessDefinitionState getState()
	{
		return state;
	}

	/**
	 * プロセス定義IDを設定する。
	 * 
	 * @param id プロセス定義ID
	 */
	void setID(String id)
	{
		this.id = id;
	}

	/**
	 * プロセス定義名を設定する。
	 * 
	 * @param name プロセス定義名
	 */
	void setName(String name)
	{
		this.name = name;
	}

	/**
	 * 備考を設定する。
	 * 
	 * @param desc 備考
	 */
	void setDescription(String desc)
	{
		this.desc = desc;
	}

	/**
	 * プロセス定義状態を設定する。
	 * 
	 * @param state プロセス定義状態
	 */
	void setState(ProcessDefinitionState state)
	{
		this.state = state;
	}
}
