/* $Id: ParticipantImpl.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.NotAssignedException;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;

/**
 * ワークフロー参加者の実装クラスである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ParticipantImpl implements Participant
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** システムID */
	public static final String SYSTEM_ID   = "__SYSTEM__";
	/** システムユーザ */
	public static final String SYSTEM_NAME = "NAUTICA SYSTEM";

	/** システム参加者 */
	private static final Participant SYSTEM_PARTICIPANT
		= new ParticipantImpl(SYSTEM_ID, SYSTEM_NAME, Participant.SYSTEM);
	
	/** 参加者ID */
	private String id;
	/** 参加者名 */
	private String name;
	/** 参加者型 */
	private int type;
	
	/**
	 * システム参加者を取得する。
	 *
	 * @return システム参加者
	 */
	public static Participant getSystemParticipant()
	{
		return SYSTEM_PARTICIPANT;
	}

	/**
	 * ワークフロー参加者を生成する。
	 */
	public ParticipantImpl(String id, String name, int type)
	{
		this.id = id;
		this.name = name;
		this.type = type;
	}

	/**
	 * IDを返す。
	 *
	 * @return ID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getID() throws WorkflowException
	{
		return id;
	}

	/**
	 * 名称を返す
	 *
	 * @return 名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getName() throws WorkflowException
	{
		return name;
	}

	/**
	 * 参加者型を返す。
	 * 
	 * @return	参加者型
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getType() throws WorkflowException
	{
		return type;
	}

	/**
	 * 保持する属性を返す。
	 *
	 * @param name 属性名
	 * @return 属性値
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String getAttribute(String name)
	throws WorkflowException
	{
		return null;
	}

	/**
	 * 属性を設定する。
	 *
	 * @param name 属性名
	 * @param value 属性値
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void setAttribute(String name, String value)
	throws WorkflowException
	{
	}

	/**
	 * 保持するすべての属性名を返す。
	 *
	 * @return 属性名の一覧
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public String[] getAllAttributeNames()
	throws WorkflowException
	{
		return null;
	}

	/**
	 * リソースに関連付けられたアサインメントの個数を返す。
	 *
	 * @return 名称
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public int getWorkItemCount() throws WorkflowException
	{
		return 0;
	}

	/**
	 * インデクスで指定されたアサインメントを返す。
	 *
	 * @param index インデクス
	 * @return アサインメント
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfAssignment getWorkItem(int index) throws WorkflowException
	{
		return null;
	}

	/**
	 * リソースに関連付けられたすべてのアサインメントを返す。
	 *
	 * @return アサインメントの一覧
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public WfAssignment[] getAllWorkItem() throws WorkflowException
	{
		return null;
	}

	/**
	 * 引数で指定されたアサインメントと、関連を持つかどうかを返す。
	 *
	 * @param ass アサインメント
	 * @return 関連を持つ場合はtrue
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public boolean isMemberOfWorkItems(WfAssignment ass)
	throws WorkflowException
	{
		return false;
	}

	/**
	 * 引数に指定したアサインメントにとって、
	 * リソースが不要になったことを通知するリスナーインタフェース。
	 * 引数として、もうリソースに関連付けられていないアサインメントと、
	 * リソースを解放する理由をとる。
	 * このインタフェースは、アサインメントが削除された場合や、
	 * アサインメントが他のリソースへ再割り当てされた場合に
	 * 内部的に呼び出されることを想定している。
	 *
	 * @param ass アサインメント
	 * @param info 開放する理由
	 * @throws NotAssignedException アサインメントが関連していない場合
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 */
	public void release(WfAssignment ass, String info)
	throws NotAssignedException, WorkflowException
	{
	}
}
