/* $Id: MessageTransporter.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.jms.MessagingException;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;

/**
 * 指定されたキューに対するメッセージ配送機能
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class MessageTransporter
{
	/** エンジンログ */
	@SuppressWarnings("unused")
	private static Logger eLog = LogManager.getEngineLogger();
	/** キュー名 */
	private String queueName;
	
	/**
	 * 指定されたキューに対するメッセージ配送機能を生成する。
	 *
	 * @param queueName キュー名
	 */
	MessageTransporter(String queueName)
	{
		this.queueName = queueName;
	}
	
	/**
	 * メッセージキューにメッセージを送る。
	 *
	 * @param msg メッセージ
	 * @throws MessagingException 送信時に例外が発生した場合
	 */
	public void sendMessage(WorkflowMessage msg)
	throws MessagingException
	{
		MessageBroker broker = MessageBroker.getInstance();
		WorkflowMQ mq = broker.getWorkflowMQ(queueName);
		mq.send(msg);
	}
}
