/* $Id: GeneralRequester.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.InvalidPerformerException;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;

/**
 * クライアントからの要求を受けてプロセスマネージャにプロセスの生成を
 * 要求する。
 * 現在のところ、このクラスは内部処理の互換性のためだけに提供されており、
 * 提供メソッドは機能しない。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class GeneralRequester implements WfRequester
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** リソース */
	private WfResource resource;
	
	/**
	 * プロセス生成リクエスタを生成する。
	 */
	public GeneralRequester(WfResource rsc)
	{
		this.resource = rsc;
	}

	/**
	 * このリクエスタから作られたプロセスの数を返す。
	 *
	 * @return プロセス数
	 * @throws WorkflowException 処理中に例外が起こった場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getPerformerCount()
	 */
	public int getPerformerCount() throws WorkflowException
	{
		return 0;
	}

	/**
	 * インデクスで指定されたプロセスを返す。
	 *
	 * @param index インデクス
	 * @return プロセス
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getPerformer(int)
	 */
	public WfProcess getPerformer(int index) throws WorkflowException
	{
		return null;
	}

	/**
	 * 管理下のすべてのプロセスを返す。
	 *
	 * @return プロセス
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getAllPerformers()
	 */
	public WfProcess[] getAllPerformers() throws WorkflowException
	{
		return null;
	}

	/**
	 * 引数で指定されたプロセスが、管理下にあるかどうかを返す。
	 *
	 * @param proc プロセス
	 * @return 管理下にある場合はtrue
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#isMemberOfPerformer(jp.co.argo21.nautica.workflow.omg.WfProcess)
	 */
	public boolean isMemberOfPerformer(WfProcess proc) throws WorkflowException
	{
		return false;
	}

	/**
	 * プロセスマネージャからの通知を受け取るリスナーインタフェース。
	 *
	 * @param event
	 * @throws InvalidPerformerException
	 * @throws WorkflowException 処理中に例外が起こった場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#receiveEvent(jp.co.argo21.nautica.workflow.omg.WfEvent)
	 */
	public void receiveEvent(WfEvent event) throws InvalidPerformerException,
			WorkflowException
	{
		String E0900 = StringManager.get("E0900");
		throw new UnsupportedOperationException(E0900);
	}

	/**
	 * リクエスタに関連するリソースを返す。
	 *
	 * @return リクエスタの主体となったリソース
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfRequester#getReqesterResource()
	 */
	public WfResource getReqesterResource() throws WorkflowException
	{
		return resource;
	}
}
