/* $Id: BehaviorExecutor.java,v 1.2 2007/11/05 02:43:42 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;

/**
 * アクティビティ動作を排他的に実行を行うためクラス。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
final class BehaviorExecutor
{
	/**
	 * 開始処理を行う。
	 *
	 * @param behavior アクティビティ動作
	 * @param pd プロセス定義
	 * @param ad アクティビティ定義
	 * @param proc プロセス
	 * @param act アクティビティ
	 * @throws Exception 任意の例外
	 */
	public static void start(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.start(pd, ad, proc, act);
	}
	
	/**
	 * 保留処理を行う。
	 *
	 * @param behavior アクティビティ動作
	 * @param pd プロセス定義
	 * @param ad アクティビティ定義
	 * @param proc プロセス
	 * @param act アクティビティ
	 * @throws Exception 任意の例外
	 */
	public static void suspend(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.suspend(pd, ad, proc, act);
	}
	
	/**
	 * 再開処理を行う。
	 *
	 * @param behavior アクティビティ動作
	 * @param pd プロセス定義
	 * @param ad アクティビティ定義
	 * @param proc プロセス
	 * @param act アクティビティ
	 * @throws Exception 任意の例外
	 * @throws Exception
	 */
	public static void resume(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.resume(pd, ad, proc, act);
	}
	
	/**
	 * 完了処理を行う。
	 *
	 * @param behavior アクティビティ動作
	 * @param pd プロセス定義
	 * @param ad アクティビティ定義
	 * @param proc プロセス
	 * @param act アクティビティ
	 * @throws Exception 任意の例外
	 */
	public static void complete(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act)
	throws Exception
	{
		behavior.complete(pd, ad, proc, act);
	}

	/**
	 * 中止処理を行う。
	 *
	 * @param behavior アクティビティ動作
	 * @param pd プロセス定義
	 * @param ad アクティビティ定義
	 * @param proc プロセス
	 * @param act アクティビティ
	 * @throws Exception 任意の例外
	 */
	public static void abort(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		behavior.abort(pd, ad, proc, act, checkChild);
	}
	
	/**
	 * 停止処理を行う。
	 *
	 * @param behavior アクティビティ動作
	 * @param pd プロセス定義
	 * @param ad アクティビティ定義
	 * @param proc プロセス
	 * @param act アクティビティ
	 * @throws Exception 任意の例外
	 */
	public static void terminate(ActivityBehavior behavior,
			ProcessDefinition pd, ActivityDefinition ad,
			ProcessInternal proc, ActivityInternal act, boolean checkChild)
	throws Exception
	{
		behavior.terminate(pd, ad, proc, act, checkChild);
	}
}
