/* $Id: AuditPrefix.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.security.SessionManager;

/**
 * 監査ログの接頭辞(prefix)の情報を保持するクラス。
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class AuditPrefix {
    /** InitialProcessInstanceID (デフォルト = argo21) */
    private static final String INITIAL_PI_ID = "argo21";

    /** DomainID (デフォルト = nautica) */
    private static final String DOMAIN_ID = "nautica";
    
    /** NodeID (デフォルト = nautica.properties の nautica.workflow.scope の値) */
    private static final String NODE_ID
    = SystemChecker.getProperty(WorkflowEngineConstants.NAUTICA_SCOPE);    
    
    /** CurrentProcessInstanceID */
    private String currentPI = "";
    
    /** ProcessState */
    private String state = "";
    
    /** EventCode */
    private String eventcode = "";
        
    /** UserID */
    private String userID = "";

    /** InformationID (デフォルト = WfMC) */
    private String infoID = "WfMC";    
    
    /**
     * 現在のプロセスインスタンスID、プロセスインスタンスの状態、
     * ユーザIDを設定する。ユーザIDは、セッションIDを用いて取得される。
     * 
     * @param currentPI 現在のプロセスインスタンスID
     * @param eventcode イベントコード
     * @param sid セッションID
     */
    AuditPrefix(String currentPI, String eventcode, String sid) {
        this.currentPI = currentPI;
        this.eventcode = eventcode;
        
        if (sid == null || sid.trim().equals("")) {
            return;
        }
        
        /* セッションIDからユーザIDを取得し、設定 */
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
		SessionManager manager = factory.getSessionManager();
        try {
            this.userID = manager.getSessionUser(sid).getID();
        } catch (Exception e) {
            /* Ignore */
        }
    }    
    
    /**
     * プロセスインスタンスID、イベントコードを設定する。
     * 
     * @param currentPI プロセスインスタンスID
     * @param eventcode イベントコード
     */
    AuditPrefix(String currentPI, String eventcode) {
        this.currentPI = currentPI;
        this.eventcode = eventcode;
    }
    
    /**
     * イベントコードを設定する。
     * 
     * @param eventcode イベントコード
     */
    AuditPrefix(String eventcode) {
        this.eventcode = eventcode;
    }
    
    /**
     * デフォルトコンストラクタ
     */
    AuditPrefix() {
        // 何もしない
    }
    
    /**
     * 現在のプロセスインスタンスIDを設定する。
     * 
     * @param currentPI プロセスインスタンスID
     */
    void setCurrentPI(String currentPI) {
        this.currentPI = currentPI;
    }
    
    /**
     * プロセスインスタンスの現在の状態を設定する。
     * 
     * @param state 状態
     */
    void setState(String state) {
        this.state = state;
    }
    
    /**
     * イベントコードを設定する。
     * 
     * @param eventcode イベントコード
     */
    void setEventCode(String eventcode) {
        this.eventcode = eventcode;
    }
    
    /**
     * ユーザIDを設定する。
     * 
     * @param userID ユーザID
     */
    void setUserID(String userID) {
        this.userID = userID;
    }
        
    /**
     * 情報IDを設定する。
     * 情報IDのデフォルト値は WfMC である。
     * 
     * @param infoID 情報ID
     */
    void setInfoID(String infoID) {
        this.infoID = infoID;
    }
    
    /**
     * CWAD接頭辞の文字列表現を返す。
     * 
     * @return CWAD接頭辞情報
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(InitialProcessInstanceID="+ INITIAL_PI_ID + ")");
        sb.append("(DomainID=" + DOMAIN_ID + ")");
        sb.append("(NodeID=" + NODE_ID + ")");
        sb.append("(CurrentProcessInstanceID=" + currentPI + ")");
        sb.append("(ProcessState=" + state + ")");
        sb.append("(EventCode=" + eventcode + ")");
        sb.append("(UserID=" + userID + ")");
        sb.append("(InformationID=" + infoID + ")");
        
        return sb.toString();
    }
}