/* $Id: AssignmentEventObject.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent;
import jp.co.argo21.nautica.workflow.omg.WfExecutionObject;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

/**
 * 割り当てイベントを表す。このクラスは、互換性のために用意されているだけで
 * 現在のエンジンでは使われていない。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class AssignmentEventObject extends WorkflowEventObject
implements WfAssignmentEvent
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** 旧リソースID */
	private String oldResourceID;
	
	/**  旧リソース名 */
	private String oldResourceName;
	
	/** 新リソースID */
	private String newResourceID;
	
	/** 新リソース名 */
	private String newResourceName;
	
	/**
	 * 割り当てイベントを生成する。
	 *
	 * @param type イベントの種類
	 * @param source イベントを引き起こしたWfExecutionObject
	 * @param timestamp イベント発生日時
	 * @param processManagerName プロセスマネージャ名
	 * @param processManagerVersion プロセスマネージャのバージョン
	 * @param processID プロセスID
	 * @param processName プロセス名
	 * @param activityID アクティビティID
	 * @param activityName アクティビティ名
	 * @param oldResourceID 旧リソースID
	 * @param oldResourceName 旧リソース名
	 * @param newResourceID 新リソースID
	 * @param newResourceName 新リソース名
	 */
	public AssignmentEventObject(String type, WfExecutionObject source,
			String timestamp, String processManagerName,
			String processManagerVersion, String processID, String processName,
			String activityID, String activityName, String oldResourceID,
			String oldResourceName, String newResourceID, String newResourceName)
	{
		super(type, source, timestamp, processManagerName,
				processManagerVersion, processID, processName, activityID,
				activityName);
		this.oldResourceID = oldResourceID;
		this.oldResourceName = oldResourceName;
		this.newResourceID = newResourceID;
		this.newResourceName = newResourceName;
	}

	/**
	 * 旧リソースIDを返す。
	 *
	 * @return リソースID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getOldResourceID()
	 */
	public String getOldResourceID() throws WorkflowException
	{
		return oldResourceID;
	}

	/**
	 * 旧リソース名を返す。
	 *
	 * @return リソース名
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getOldResourceName()
	 */
	public String getOldResourceName() throws WorkflowException
	{
		return oldResourceName;
	}

	/**
	 * 新リソースIDを返す。
	 *
	 * @return リソースID
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getNewResourceID()
	 */
	public String getNewResourceID() throws WorkflowException
	{
		return newResourceID;
	}

	/**
	 * 新リソース名を返す。
	 *
	 * @return リソース名
	 * @throws WorkflowException　ワークフロー関連で例外が発生した場合
	 * @see jp.co.argo21.nautica.workflow.omg.WfAssignmentEvent#getNewResourceName()
	 */
	public String getNewResourceName() throws WorkflowException
	{
		return newResourceName;
	}
}
