/* $Id: UserManagerBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ejb;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

import jp.co.argo21.nautica.workflow.security.InvalidRoleException;
import jp.co.argo21.nautica.workflow.security.InvalidUserException;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

/**
 * UserManagerBean は、ローカルの UserManager に対する
 * リモート呼び出しを実現する具体実装クラスである。
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
@Stateless
@Remote(UserManager.class)
@TransactionManagement(TransactionManagementType.CONTAINER)
public class UserManagerBean implements UserManager
{
	/**
	 * uidに対応するユーザを返す。
	 * uidに対応するユーザが存在しない場合は null を返す。
	 *
	 * @param uid ユーザID
	 * @return ユーザ
	 * @throws InvalidRoleException 指定されたユーザが有効でない場合
	 * @throws WorkflowSecurityException その他のセキュリティ例外
	 */
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
	public User getUser(String uid) 
	throws InvalidUserException, WorkflowSecurityException
	{
		UserManager um = ComponentUtils.getUserManager();
		return um.getUser(uid);
	}
}
