/* $Id: RepositoryLoaderBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.ejb;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

import jp.co.argo21.nautica.workflow.engine.RepositoryLoader;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;

/**
 * RepositoryLoaderBean は、ローカルの RepositoryLoader に対する
 * リモート呼び出しを実現する具体実装クラスである。
 *
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
@Stateless
@Remote(RepositoryLoader.class)
@TransactionManagement(TransactionManagementType.CONTAINER)
public class RepositoryLoaderBean
implements RepositoryLoader
{
    /**
     * 指定されたパスの定義ファイルを文字列で返す。
     * なければ null を返す。
     * RemoteException 以外の例外が発生した場合も null を返す。
     * 
     * @param sid      セッションID
     * @param password 管理用パスワード
     * @param path     パス名
     * @return 定義ファイルの文字列
     */
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
 	public String getDefinition(String sid, String password, String path)
	throws InvalidSessionException
	{
		RepositoryLoader repository = ComponentUtils.getRepositoryLoader(sid);
		return repository.getDefinition(sid, password, path);               
    }
    
    /**
     * 指定されたプロセス定義名に対応するパス名を返す。
     * なければ null を返す。
     * RemoteException 以外の例外が発生した場合も null を返す。
     * 
     * @param sid    セッションID
     * @param pdname プロセス定義名
     * @return パス名
     */
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
	public String getDefinitionPath(String sid, String pdname)
	throws InvalidSessionException
	{
		RepositoryLoader repository = ComponentUtils.getRepositoryLoader(sid);
		return repository.getDefinitionPath(sid, pdname);
    }
}
