/* $Id: VariableDefinitionImpl.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;

import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * VariableDefinitionインタフェースの実装クラスである。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class VariableDefinitionImpl implements VariableDefinition
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/** 名称 */
	private String name;
	/** 備考 */
	private String description;
	/** 型 */
	private int type;
	/** 初期値 */
	private String initialValue;
	/** 初期化済みフラグ */
	private boolean isInitialized;

	/**
	 * プロセス変数を生成する。
	 * 
	 * @param df	XmlObject
	 */
	public VariableDefinitionImpl(DataFieldDocument.DataField df)
	{
		String id = df.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(df.getName());
		setDescription(df.getDescription());
		setInitialValue(df.getInitialValue());
		
		DataTypeDocument.DataType t = df.getDataType();
		if (t != null && t.isSetBasicType()) {
			BasicTypeDocument.BasicType bt = t.getBasicType();
			BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
			setType(type.intValue());
			isInitialized = true;
		} else {
			setType(STRING);
			isInitialized = false;
		}
	}

	/**
	/**
	 * 初期化済みかどうかを返す。
	 * 
	 * @return	初期化済みならtrue
	 * @see jp.co.argo21.nautica.workflow.definition.VariableDefinition#isInitialized()
	 */
	public boolean isInitialized()
	{
		return isInitialized;
	}

	/**
	 * 説明を返す。
	 * 
	 * @return 説明
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * 初期値を返す。
	 * 
	 * @return	初期値
	 * @see jp.co.argo21.nautica.workflow.definition.VariableDefinition#getInitialValue()
	 */
	public String getInitialValue()
	{
		return initialValue;
	}

	/**
	 * 型を返す。
	 * 
	 * @return	型
	 * @see jp.co.argo21.nautica.workflow.definition.VariableDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * 説明を設定する。
	 * 
	 * @param desc 説明
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * 名称を設定する。
	 * 
	 * @param name 名称
	 */
	private void setName(String name)
	{
		this.name = name;
	}

	/**
	 * 初期値を設定する。
	 * 
	 * @param v	初期値
	 */
	private void setInitialValue(String v)
	{
		initialValue = v;
	}

	/**
	 * 型を設定する。
	 * 
	 * @param i	型
	 */
	private void setType(int i)
	{
		type = i;
		isInitialized = true;
	}
}
