/* $Id: ParticipantDefinitionImpl.java,v 1.1 2007/10/29 02:55:37 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantTypeDocument;

import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;

/**
 * ParticipantDefinitionインタフェースの実装クラスである。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ParticipantDefinitionImpl implements ParticipantDefinition
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID */
	private String id;
	/** 名称 */
	private String name;
	/** 備考 */
	private String description;
	/** 参加者型 */
	private int type;
	
	/**
	 * ワークフロー参加者を生成する。
	 * 
	 * @param pt	XmlObject
	 */
	public ParticipantDefinitionImpl(ParticipantDocument.Participant pt)
	{
		String id = pt.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(pt.getName());
		setDescription(pt.getDescription());
		
		ParticipantTypeDocument.ParticipantType ptype = pt.getParticipantType();
		ParticipantTypeDocument.ParticipantType.Type.Enum type = ptype.getType();
		setType(type.intValue());
	}

	/**
	 * 参加者型を返す。
	 * 
	 * @return	参加者型
	 * @see jp.co.argo21.nautica.workflow.definition.ParticipantDefinition#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * 説明を返す。
	 * 
	 * @return 説明
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 * @see jp.co.argo21.nautica.workflow.definition.Definition#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * 参加者型を設定する。
	 * 
	 * @param type	参加者型
	 */
	private void setType(int type)
	{
		this.type = type;
	}

	/**
	 * 説明を設定する。
	 * 
	 * @param desc 説明
	 */
	private void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * 名称を設定する。
	 * 
	 * @param name 名称
	 */
	private void setName(String name)
	{
		this.name = name;
	}
}
