/* $Id: TransitionDefinition.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition;

import jp.co.argo21.nautica.workflow.expression.Expression;

import org.wfmc.x2002.xpdl10.ConditionDocument;

/**
 * 遷移定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface TransitionDefinition extends Definition
{
	/** 遷移ID接頭辞 */
	public static final String ID_PREFIX  = "TR";

	/** 条件 */
	public static final int CONDITION        = ConditionDocument.Condition.Type.INT_CONDITION;
	/** その他 */
	public static final int OTHERWISE        = ConditionDocument.Condition.Type.INT_OTHERWISE;
	/** 例外 */
	public static final int EXCEPTION        = ConditionDocument.Condition.Type.INT_EXCEPTION;
	/** デフォルト例外 */
	public static final int DEFAULTEXCEPTION = ConditionDocument.Condition.Type.INT_DEFAULTEXCEPTION;

	/**
	 * 遷移元アクティビティを返す。
	 * 
	 * @return	遷移元アクティビティ
	 */
	public ActivityDefinition getSource();

	/**
	 * 遷移先アクティビティを返す。
	 * 
	 * @return	遷移先アクティビティ
	 */
	public ActivityDefinition getDestination();

	/**
	 * 遷移条件を返す。
	 * 
	 * @return	遷移条件
	 */
	public Expression getCondition();

	/**
	 * 遷移型を返す。
	 * 
	 * @return	遷移型
	 */
	public int getType();
}
