/* $Id: PackageDefinition.java,v 1.2 2007/11/05 09:50:54 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.definition;

import java.util.List;

/**
 * パッケージ定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface PackageDefinition extends Definition
{
	/** パッケージID接頭辞 */
	public static final String ID_PREFIX  = "PK";

	/**
	 * 作成日を返す。
	 * 
	 * @return	作成日
	 */
	public String getCreatedDate();
	
	/**
	 * 定義者を返す。
	 * 
	 * @return	定義者
	 */
	public String getAuthor();
	
	/**
	 * バージョンを返す。
	 * 
	 * @return	バージョン
	 */
	public String getVersion();
	
	/**
	 * ワークフロー参加者一覧を返す。
	 * 
	 * @return	ワークフロー参加者一覧
	 */
	public List<ParticipantDefinition> getParticipants();
	
	/**
	 * アプリケーション一覧を返す。
	 * 
	 * @return	アプリケーション一覧
	 */
	public List<ApplicationDefinition> getApplications();
	
	/**
	 * プロセス変数一覧を返す。
	 * 
	 * @return	プロセス変数一覧
	 */
	public List<VariableDefinition> getVariables();
	
	/**
	 * プロセス一覧を返す。
	 * 
	 * @return	プロセス一覧
	 */
	public List<ProcessDefinition> getProcesses();
}
