/* $Id: DerbyDAOFactory.java,v 1.1 2007/11/13 08:51:28 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess.derby;

import java.sql.Connection;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationTypeDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ConcurrencyBlockDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.RoleManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.SequencerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;

/**
 * Derby用のワークフロー関連テーブルに対する各種DAOを生成するファクトリークラス。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DerbyDAOFactory implements WorkflowDAOFactory
{
	/** エンジンログ */
	protected static Logger eLog = LogManager.getEngineLogger();

	/**
	 * ファクトリーを生成する。
	 */
	public DerbyDAOFactory()
	{
	}

	/**
	 * ActivityDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ActivityDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityDAO(java.sql.Connection)
	 */
	public ActivityDAO getActivityDAO(Connection conn) throws Exception
	{
		return new DerbyActivityDAO(conn);
	}

	/**
	 * ActivityHistoryDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ActivityHistoryDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityHistoryDAO(java.sql.Connection)
	 */
	public ActivityHistoryDAO getActivityHistoryDAO(Connection conn)
			throws Exception
	{
		return new DerbyActivityHistoryDAO(conn);
	}

	/**
	 * AppExecutionDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return AppExecutionDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getAppExecutionDAO(java.sql.Connection)
	 */
	public AppExecutionDAO getAppExecutionDAO(Connection conn) throws Exception
	{
		return new DerbyAppExecutionDAO(conn);
	}

	/**
	 * ApplicationDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ApplicationDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationDAO(java.sql.Connection)
	 */
	public ApplicationDAO getApplicationDAO(Connection conn) throws Exception
	{
		return new DerbyApplicationDAO(conn);
	}

	/**
	 * ApplicationTypeDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ApplicationTypeDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationTypeDAO(java.sql.Connection)
	 */
	public ApplicationTypeDAO getApplicationTypeDAO(Connection conn)
			throws Exception
	{
		return new DerbyApplicationTypeDAO(conn);
	}

	/**
	 * ConcurrencyBlockDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ConcurrencyBlockDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getConcurrencyBlockDAO(java.sql.Connection)
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO(Connection conn)
			throws Exception
	{
		return new DerbyConcurrencyBlockDAO(conn);
	}

	/**
	 * DefinitionDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return DefinitionDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getDefinitionDAO(java.sql.Connection)
	 */
	public DefinitionDAO getDefinitionDAO(Connection conn) throws Exception
	{
		return new DerbyDefinitionDAO(conn);
	}

	/**
	 * ProcessDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ProcessDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessDAO(java.sql.Connection)
	 */
	public ProcessDAO getProcessDAO(Connection conn) throws Exception
	{
		return new DerbyProcessDAO(conn);
	}

	/**
	 * ProcessHistoryDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ProcessHistoryDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessHistoryDAO(java.sql.Connection)
	 */
	public ProcessHistoryDAO getProcessHistoryDAO(Connection conn)
			throws Exception
	{
		return new DerbyProcessHistoryDAO(conn);
	}

	/**
	 * ProcessWaitActivityDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ProcessWaitActivityDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessWaitActivityDAO(java.sql.Connection)
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO(Connection conn)
			throws Exception
	{
		return new DerbyProcessWaitActivityDAO(conn);
	}

	/**
	 * SequencerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return SequencerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSequencerDAO(java.sql.Connection)
	 */
	public SequencerDAO getSequencerDAO(Connection conn) throws Exception
	{
		return new DerbySequencerDAO(conn);
	}

	/**
	 * SourceActivityDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return SourceActivityDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSourceActivityDAO(java.sql.Connection)
	 */
	public SourceActivityDAO getSourceActivityDAO(Connection conn)
			throws Exception
	{
		return new DerbySourceActivityDAO(conn);
	}

	/**
	 * TargetProcessDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return TargetProcessDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getTargetProcessDAO(java.sql.Connection)
	 */
	public TargetProcessDAO getTargetProcessDAO(Connection conn)
			throws Exception
	{
		return new DerbyTargetProcessDAO(conn);
	}

	/**
	 * VariableDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return VariableDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableDAO(java.sql.Connection)
	 */
	public VariableDAO getVariableDAO(Connection conn) throws Exception
	{
		return new DerbyVariableDAO(conn);
	}

	/**
	 * VariableHistoryDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return VariableHistoryDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableHistoryDAO(java.sql.Connection)
	 */
	public VariableHistoryDAO getVariableHistoryDAO(Connection conn)
			throws Exception
	{
		return new DerbyVariableHistoryDAO(conn);
	}

	/**
	 * WorkItemDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return WorkItemDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getWorkItemDAO(java.sql.Connection)
	 */
	public WorkItemDAO getWorkItemDAO(Connection conn) throws Exception
	{
		return new DerbyWorkItemDAO(conn);
	}
	
	/**
	 * OrganizationManagerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return OrganizationManagerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getOrganizationManagerDAO(java.sql.Connection)
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO(Connection conn) 
	        throws Exception
	{
	    return new DerbyOrganizationManagerDAO(conn);
	}

	/**
	 * RoleManagerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return RoleManagerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getRoleManagerDAO(java.sql.Connection)
	 */
	public RoleManagerDAO getRoleManagerDAO(Connection conn) throws Exception
	{
	    return new DerbyRoleManagerDAO(conn);
	}

	/**
	 * UserManagerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return UserManagerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getUserManagerDAO(java.sql.Connection)
	 */
	public UserManagerDAO getUserManagerDAO(Connection conn) throws Exception
	{
	    return new DerbyUserManagerDAO(conn);
	}
	
	/**
	 * ActivityDAOを返す。
	 *
	 * @return ActivityDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityDAO(java.sql.Connection)
	 */
	public ActivityDAO getActivityDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyActivityDAO(conn);
	}

	/**
	 * ActivityHistoryDAOを返す。
	 *
	 * @return ActivityHistoryDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getActivityHistoryDAO()
	 */
	public ActivityHistoryDAO getActivityHistoryDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyActivityHistoryDAO(conn);
	}

	/**
	 * AppExecutionDAOを返す。
	 *
	 * @return AppExecutionDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getAppExecutionDAO()
	 */
	public AppExecutionDAO getAppExecutionDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyAppExecutionDAO(conn);
	}

	/**
	 * ApplicationDAOを返す。
	 *
	 * @return ApplicationDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationDAO()
	 */
	public ApplicationDAO getApplicationDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyApplicationDAO(conn);
	}

	/**
	 * ApplicationTypeDAOを返す。
	 *
	 * @return ApplicationTypeDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getApplicationTypeDAO()
	 */
	public ApplicationTypeDAO getApplicationTypeDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyApplicationTypeDAO(conn);
	}

	/**
	 * ConcurrencyBlockDAOを返す。
	 *
	 * @return ConcurrencyBlockDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getConcurrencyBlockDAO()
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyConcurrencyBlockDAO(conn);
	}

	/**
	 * DefinitionDAOを返す。
	 *
	 * @return DefinitionDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getDefinitionDAO()
	 */
	public DefinitionDAO getDefinitionDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyDefinitionDAO(conn);
	}

	/**
	 * ProcessDAOを返す。
	 *
	 * @return ProcessDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessDAO()
	 */
	public ProcessDAO getProcessDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyProcessDAO(conn);
	}

	/**
	 * ProcessHistoryDAOを返す。
	 *
	 * @return ProcessHistoryDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessHistoryDAO()
	 */
	public ProcessHistoryDAO getProcessHistoryDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyProcessHistoryDAO(conn);
	}

	/**
	 * ProcessWaitActivityDAOを返す。
	 *
	 * @return ProcessWaitActivityDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getProcessWaitActivityDAO()
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyProcessWaitActivityDAO(conn);
	}

	/**
	 * SequencerDAOを返す。
	 *
	 * @return SequencerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSequencerDAO()
	 */
	public SequencerDAO getSequencerDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbySequencerDAO(conn);
	}

	/**
	 * SourceActivityDAOを返す。
	 *
	 * @return SourceActivityDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getSourceActivityDAO()
	 */
	public SourceActivityDAO getSourceActivityDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbySourceActivityDAO(conn);
	}

	/**
	 * TargetProcessDAOを返す。
	 *
	 * @return TargetProcessDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getTargetProcessDAO()
	 */
	public TargetProcessDAO getTargetProcessDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyTargetProcessDAO(conn);
	}

	/**
	 * VariableDAOを返す。
	 *
	 * @return VariableDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableDAO()
	 */
	public VariableDAO getVariableDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyVariableDAO(conn);
	}

	/**
	 * VariableHistoryDAOを返す。
	 *
	 * @return VariableHistoryDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getVariableHistoryDAO()
	 */
	public VariableHistoryDAO getVariableHistoryDAO()
			throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyVariableHistoryDAO(conn);
	}

	/**
	 * WorkItemDAOを返す。
	 *
	 * @return WorkItemDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getWorkItemDAO()
	 */
	public WorkItemDAO getWorkItemDAO() throws Exception
	{
		Connection conn = DataAccessManager.getConnection();
		return new DerbyWorkItemDAO(conn);
	}
	
	/**
	 * OrganizationManagerDAOを返す。
	 *
	 * @return OrganizationManagerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getOrganizationManagerDAO()
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO() 
	        throws Exception
	{
	    Connection conn = DataAccessManager.getConnection();
	    return new DerbyOrganizationManagerDAO(conn);
	}

	/**
	 * RoleManagerDAOを返す。
	 *
	 * @return RoleManagerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getRoleManagerDAO()
	 */
	public RoleManagerDAO getRoleManagerDAO() throws Exception
	{
	    Connection conn = DataAccessManager.getConnection();
	    return new DerbyRoleManagerDAO(conn);
	}
	
	/**
	 * UserManagerDAOを返す。
	 *
	 * @return UserManagerDAO
	 * @throws Exception 任意の例外
	 * @see jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory#getUserManagerDAO()
	 */
	public UserManagerDAO getUserManagerDAO() throws Exception
	{
	    Connection conn = DataAccessManager.getConnection();
	    return new DerbyUserManagerDAO(conn);
	}
}
