/* $Id: WorkflowDAOFactory.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.Connection;

/**
 * エンジン内で使用する各種DAO(Data Access Object)のファクトリである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkflowDAOFactory
{
	/**
	 * ActivityDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ActivityDAO
	 * @throws Exception 任意の例外
	 */
	public ActivityDAO getActivityDAO(Connection conn)
		throws Exception;

	/**
	 * ActivityHistoryDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ActivityHistoryDAO
	 * @throws Exception 任意の例外
	 */
	public ActivityHistoryDAO getActivityHistoryDAO(Connection conn)
		throws Exception;

	/**
	 * AppExecutionDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return AppExecutionDAO
	 * @throws Exception 任意の例外
	 */
	public AppExecutionDAO getAppExecutionDAO(Connection conn)
		throws Exception;

	/**
	 * ApplicationDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ApplicationDAO
	 * @throws Exception 任意の例外
	 */
	public ApplicationDAO getApplicationDAO(Connection conn)
		throws Exception;

	/**
	 * ApplicationTypeDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ApplicationTypeDAO
	 * @throws Exception 任意の例外
	 */
	public ApplicationTypeDAO getApplicationTypeDAO(Connection conn)
		throws Exception;

	/**
	 * ConcurrencyBlockDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ConcurrencyBlockDAO
	 * @throws Exception 任意の例外
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO(Connection conn)
		throws Exception;

	/**
	 * DefinitionDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return DefinitionDAO
	 * @throws Exception 任意の例外
	 */
	public DefinitionDAO getDefinitionDAO(Connection conn)
		throws Exception;

	/**
	 * ProcessDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ProcessDAO
	 * @throws Exception 任意の例外
	 */
	public ProcessDAO getProcessDAO(Connection conn)
		throws Exception;

	/**
	 * ProcessHistoryDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ProcessHistoryDAO
	 * @throws Exception 任意の例外
	 */
	public ProcessHistoryDAO getProcessHistoryDAO(Connection conn)
		throws Exception;

	/**
	 * ProcessWaitActivityDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return ProcessWaitActivityDAO
	 * @throws Exception 任意の例外
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO(Connection conn)
		throws Exception;

	/**
	 * SequencerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return SequencerDAO
	 * @throws Exception 任意の例外
	 */
	public SequencerDAO getSequencerDAO(Connection conn)
		throws Exception;

	/**
	 * SourceActivityDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return SourceActivityDAO
	 * @throws Exception 任意の例外
	 */
	public SourceActivityDAO getSourceActivityDAO(Connection conn)
		throws Exception;

	/**
	 * TargetProcessDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return TargetProcessDAO
	 * @throws Exception 任意の例外
	 */
	public TargetProcessDAO getTargetProcessDAO(Connection conn)
		throws Exception;

	/**
	 * VariableDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return VariableDAO
	 * @throws Exception 任意の例外
	 */
	public VariableDAO getVariableDAO(Connection conn)
		throws Exception;

	/**
	 * VariableHistoryDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return VariableHistoryDAO
	 * @throws Exception 任意の例外
	 */
	public VariableHistoryDAO getVariableHistoryDAO(Connection conn)
		throws Exception;

	/**
	 * WorkItemDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return WorkItemDAO
	 * @throws Exception 任意の例外
	 */
	public WorkItemDAO getWorkItemDAO(Connection conn)
		throws Exception;
	
	/**
	 * OrganizationManagerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return OrganizationManagerDAO
	 * @throws Exception 任意の例外
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO(Connection conn)
	    throws Exception;
	
	/**
	 * RoleManagerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return RoleManagerDAO
	 * @throws Exception 任意の例外
	 */
	public RoleManagerDAO getRoleManagerDAO(Connection conn)
	    throws Exception;
	
	/**
	 * UserManagerDAOを返す。
	 *
	 * @param conn JDBC接続
	 * @return UserManagerDAO
	 * @throws Exception 任意の例外
	 */
	public UserManagerDAO getUserManagerDAO(Connection conn)
	    throws Exception;
	
	/**
	 * ActivityDAOを返す。
	 *
	 * @return ActivityDAO
	 * @throws Exception 任意の例外
	 */
	public ActivityDAO getActivityDAO()
		throws Exception;

	/**
	 * ActivityHistoryDAOを返す。
	 *
	 * @return ActivityHistoryDAO
	 * @throws Exception 任意の例外
	 */
	public ActivityHistoryDAO getActivityHistoryDAO()
		throws Exception;

	/**
	 * AppExecutionDAOを返す。
	 *
	 * @return AppExecutionDAO
	 * @throws Exception 任意の例外
	 */
	public AppExecutionDAO getAppExecutionDAO()
		throws Exception;

	/**
	 * ApplicationDAOを返す。
	 *
	 * @return ApplicationDAO
	 * @throws Exception 任意の例外
	 */
	public ApplicationDAO getApplicationDAO()
		throws Exception;

	/**
	 * ApplicationTypeDAOを返す。
	 *
	 * @return ApplicationTypeDAO
	 * @throws Exception 任意の例外
	 */
	public ApplicationTypeDAO getApplicationTypeDAO()
		throws Exception;

	/**
	 * ConcurrencyBlockDAOを返す。
	 *
	 * @return ConcurrencyBlockDAO
	 * @throws Exception 任意の例外
	 */
	public ConcurrencyBlockDAO getConcurrencyBlockDAO()
		throws Exception;

	/**
	 * DefinitionDAOを返す。
	 *
	 * @return DefinitionDAO
	 * @throws Exception 任意の例外
	 */
	public DefinitionDAO getDefinitionDAO()
		throws Exception;

	/**
	 * ProcessDAOを返す。
	 *
	 * @return ProcessDAO
	 * @throws Exception 任意の例外
	 */
	public ProcessDAO getProcessDAO()
		throws Exception;

	/**
	 * ProcessHistoryDAOを返す。
	 *
	 * @return ProcessHistoryDAO
	 * @throws Exception 任意の例外
	 */
	public ProcessHistoryDAO getProcessHistoryDAO()
		throws Exception;

	/**
	 * ProcessWaitActivityDAOを返す。
	 *
	 * @return ProcessWaitActivityDAO
	 * @throws Exception 任意の例外
	 */
	public ProcessWaitActivityDAO getProcessWaitActivityDAO()
		throws Exception;

	/**
	 * SequencerDAOを返す。
	 *
	 * @return SequencerDAO
	 * @throws Exception 任意の例外
	 */
	public SequencerDAO getSequencerDAO()
		throws Exception;

	/**
	 * SourceActivityDAOを返す。
	 *
	 * @return SourceActivityDAO
	 * @throws Exception 任意の例外
	 */
	public SourceActivityDAO getSourceActivityDAO()
		throws Exception;

	/**
	 * TargetProcessDAOを返す。
	 *
	 * @return TargetProcessDAO
	 * @throws Exception 任意の例外
	 */
	public TargetProcessDAO getTargetProcessDAO()
		throws Exception;

	/**
	 * VariableDAOを返す。
	 *
	 * @return VariableDAO
	 * @throws Exception 任意の例外
	 */
	public VariableDAO getVariableDAO()
		throws Exception;

	/**
	 * VariableHistoryDAOを返す。
	 *
	 * @return VariableHistoryDAO
	 * @throws Exception 任意の例外
	 */
	public VariableHistoryDAO getVariableHistoryDAO()
		throws Exception;

	/**
	 * WorkItemDAOを返す。
	 *
	 * @return WorkItemDAO
	 * @throws Exception 任意の例外
	 */
	public WorkItemDAO getWorkItemDAO()
		throws Exception;
	
	/**
	 * OrganizationManagerDAOを返す。
	 *
	 * @return OrganizationManagerDAO
	 * @throws Exception 任意の例外
	 */
	public OrganizationManagerDAO getOrganizationManagerDAO()
	    throws Exception;
	
	/**
	 * RoleManagerDAOを返す。
	 *
	 * @return RoleManagerDAO
	 * @throws Exception 任意の例外
	 */
	public RoleManagerDAO getRoleManagerDAO()
	    throws Exception;
	
	/**
	 * UserManagerDAOを返す。
	 *
	 * @return UserManagerDAO
	 * @throws Exception 任意の例外
	 */
	public UserManagerDAO getUserManagerDAO()
	    throws Exception;
}
