/* $Id: WorkItemBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import jp.co.argo21.nautica.workflow.wfmc.WorkItem;

/**
 * このクラスは、作業項目テーブル(WORK_ITEM)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class WorkItemBean implements WorkItem
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID接頭辞 */
	public static final String ID_PREFIX  = "WII";
	/**
	 * 作業項目ID
	 */
	protected String workID;

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * アクティビティインスタンスID
	 */
	protected String actID;

	/**
	 * ワークフロー参加者型
	 */
	protected int participantType;

	/**
	 * ワークフロー参加者名称
	 */
	protected String participantName;

	/**
	 * 作業項目オブジェクトを生成する。
	 */
	public WorkItemBean()
	{
	}

	/**
	 * 作業項目IDを取得する。
	 *
	 * @return	作業項目ID
	 */
	public String getID()
	{
		if (workID == null) return "";
		else return workID;
	}
	
	/**
	 * 作業項目IDを設定する。
	 *
	 * @param	workID	作業項目ID
	 */
	public void setID(String workID)
	{
		this.workID = workID;
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcessID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcessID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * アクティビティインスタンスIDを取得する。
	 *
	 * @return	アクティビティインスタンスID
	 */
	public String getActivityID()
	{
		if (actID == null) return "";
		else return actID;
	}
	
	/**
	 * アクティビティインスタンスIDを設定する。
	 *
	 * @param	actID	アクティビティインスタンスID
	 */
	public void setActivityID(String actID)
	{
		this.actID = actID;
	}

	/**
	 * 作業項目名を取得する。
	 *
	 * @return	作業項目名
	 */
	public String getName()
	{
		return getProcessID() + "/" + getActivityID();
	}

	/**
	 * ワークフロー参加者型を取得する。
	 *
	 * @return	ワークフロー参加者型
	 */
	public int getParticipantType()
	{
		return participantType;
	}
	
	/**
	 * ワークフロー参加者型を設定する。
	 *
	 * @param	participantType	ワークフロー参加者型
	 */
	public void setParticipantType(int participantType)
	{
		this.participantType = participantType;
	}

	/**
	 * ワークフロー参加者名称を取得する。
	 *
	 * @return	ワークフロー参加者名称
	 */
	public String getParticipantName()
	{
		if (participantName == null) return "";
		else return participantName;
	}
	
	/**
	 * ワークフロー参加者名称を設定する。
	 *
	 * @param	participantName	ワークフロー参加者名称
	 */
	public void setParticipantName(String participantName)
	{
		this.participantName = participantName;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

