/* $Id: UserManagerDAO.java,v 1.2 2007/12/07 05:04:57 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

/**
 * UserManagerDAOは、ユーザ管理関連の各種APIを定義する。
 * 永続化されているデータにアクセスするためのインタフェースである。
 * 実際には、任意のユーザ管理システムを利用するために、
 * このインタフェースを利用した具体実装を用意しなければならない。
 * 
 * @author  mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface UserManagerDAO {
    
    /**
     * 指定されたユーザIDのユーザ情報を返す。
     * 該当するユーザ情報が存在しない場合は null を返す。
     * 
     * @param  uid ユーザID
     * @return 指定されたユーザIDの情報を持つUserBean
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
     */
    public UserBean findByUserID(String uid)
    throws SQLException, DAOException;

    /**
     * 指定されたユーザIDのユーザ情報を返す。
     * 該当するユーザ情報が存在しない場合は null を返す。
     * 
     * @param  uid ユーザID
     * @param  passwd パスワード
     * @return 指定されたユーザIDの情報を持つUserBean
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
     */
    public UserBean findByUserIDAndPasswd(String uid, String passwd)
    throws SQLException, DAOException;
}