/* $Id: UserBean.java,v 1.2 2007/12/06 07:47:15 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import jp.co.argo21.nautica.workflow.security.User;

/**
 * このクラスは、ユーザ情報を保持する
 * 
 * @author mmanabe(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since Nautica Workflow 1.0
 */
public class UserBean implements User
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	private String id;

	private String firstname;

	private String lastname;

	private Map<String, String> attributes = new HashMap<String, String>();

	private int type;

	/**
	 * ユーザ情報オブジェクトを生成する。
	 * 
	 */
	public UserBean(String uid, int type)
	{
		this.id = uid;
		this.type = type;
	}

	/**
	 * ユーザIDを返す。
	 * 
	 * @return ユーザID
	 * @see jp.co.argo21.nautica.workflow.security.User#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ユーザ名を返す。
	 * 
	 * @return ユーザ名
	 * @see jp.co.argo21.nautica.workflow.security.User#getName()
	 */
	public String getName()
	{
		if (Locale.getDefault().toString().equals("ja_JP")) {
			return lastname + " " + firstname;
		} else {
			return firstname + ", " + lastname;
		}
	}

	/**
	 * ユーザのファーストネームを設定する。
	 * 
	 * @param firstname
	 *            ファーストネーム
	 */
	public void setFirstName(String firstname)
	{
		this.firstname = firstname;
	}

	/**
	 * ユーザのラストネームを設定する。
	 * 
	 * @param lastname
	 *            ラストネーム
	 */
	public void setLastName(String lastname)
	{
		this.lastname = lastname;
	}

	/**
	 * 参加者型を返す。
	 * 
	 * @return 参加者型
	 * @see jp.co.argo21.nautica.workflow.wfmc.Participant#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * 保持する属性を返す。
	 * 
	 * @param name
	 *            属性名
	 * @return 属性値
	 * @see jp.co.argo21.nautica.workflow.security.User#getAttribute(java.lang.String)
	 */
	public String getAttribute(String name)
	{
		return (String) attributes.get(name);
	}

	/**
	 * 属性を設定する。
	 * 
	 * @param name
	 *            属性名
	 * @param value
	 *            属性値
	 * @see jp.co.argo21.nautica.workflow.security.User#setAttribute(java.lang.String,
	 *      java.lang.String)
	 */
	public void setAttribute(String name, String value)
	{
		attributes.put(name, value);
	}

	/**
	 * 保持するすべての属性名を返す。
	 * 
	 * @return 属性名の一覧
	 * @see jp.co.argo21.nautica.workflow.security.User#getAllAttributeNames()
	 */
	public String[] getAllAttributeNames()
	{
		return (String[]) attributes.keySet().toArray(
				new String[attributes.size()]);
	}
}
