/* $Id: ProcessWaitActivityDAO.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;

/**
 * ProcessWaitActivityBeanをデータとするDAOインタフェース。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface ProcessWaitActivityDAO
{
	/**
	 * IDに対応するサブプロセス終了待ちアクティビティ情報を取得する。
	 *
	 * @param spid サブプロセスID
	 * @return サブプロセス終了待ちアクティビティ情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public ProcessWaitActivityBean findBySubprocessID(String spid)
	throws SQLException, DAOException;

	/**
	 * プロセスIdとアクティビティIDでサブプロセス終了待ちアクティビティ情報を取得する。
	 *
	 * @param pid プロセスID
	 * @param aid アクティビティID
	 * @return サブプロセス終了待ちアクティビティ情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public ProcessWaitActivityBean findByProcIDANDActID(String pid, String aid)
	throws SQLException, DAOException;

	/**
	 * サブプロセス終了待ちアクティビティ情報を挿入する。
	 *
	 * @param bean サブプロセス終了待ちアクティビティ情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public void insert(ProcessWaitActivityBean bean)
	throws SQLException, DAOException;

	/**
	 * サブプロセス終了待ちアクティビティ情報を削除する。
	 *
	 * @param spid サブプロセスID
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public void delete(String spid)
	throws SQLException, DAOException;
}
