/* $Id: ProcessHistoryBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * このクラスは、プロセス状態変更履歴テーブル(PROCESS_HISTORY)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class ProcessHistoryBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * パッケージID
	 */
	protected String packageID;

	/**
	 * プロセス定義ID
	 */
	protected String procDefID;

	/**
	 * 更新前の状態
	 */
	protected int prevState;

	/**
	 * 更新後の状態
	 */
	protected int newState;

	/**
	 * 更新日時
	 */
	protected Timestamp updateDate;

	/**
	 * 更新事由
	 */
	protected String reason;

	/**
	 * プロセス状態変更履歴オブジェクトを生成する。
	 */
	public ProcessHistoryBean()
	{
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * パッケージIDを取得する。
	 *
	 * @return	パッケージID
	 */
	public String getPackageID()
	{
		if (packageID == null) return "";
		else return packageID;
	}
	
	/**
	 * パッケージIDを設定する。
	 *
	 * @param	packageID	パッケージID
	 */
	public void setPackageID(String packageID)
	{
		this.packageID = packageID;
	}

	/**
	 * プロセス定義IDを取得する。
	 *
	 * @return	プロセス定義ID
	 */
	public String getProcDefID()
	{
		if (procDefID == null) return "";
		else return procDefID;
	}
	
	/**
	 * プロセス定義IDを設定する。
	 *
	 * @param	procDefID	プロセス定義ID
	 */
	public void setProcDefID(String procDefID)
	{
		this.procDefID = procDefID;
	}

	/**
	 * 更新前の状態を取得する。
	 *
	 * @return	更新前の状態
	 */
	public int getPrevState()
	{
		return prevState;
	}
	
	/**
	 * 更新前の状態を設定する。
	 *
	 * @param	prevState	更新前の状態
	 */
	public void setPrevState(int prevState)
	{
		this.prevState = prevState;
	}

	/**
	 * 更新後の状態を取得する。
	 *
	 * @return	更新後の状態
	 */
	public int getNewState()
	{
		return newState;
	}
	
	/**
	 * 更新後の状態を設定する。
	 *
	 * @param	newState	更新後の状態
	 */
	public void setNewState(int newState)
	{
		this.newState = newState;
	}

	/**
	 * 更新日時を取得する。
	 *
	 * @return	更新日時
	 */
	public Timestamp getUpdateDate()
	{
		return updateDate;
	}
	
	/**
	 * 更新日時を設定する。
	 *
	 * @param	updateDate	更新日時
	 */
	public void setUpdateDate(Timestamp updateDate)
	{
		this.updateDate = updateDate;
	}

	/**
	 * 更新事由を取得する。
	 *
	 * @return	更新事由
	 */
	public String getReason()
	{
		if (reason == null) return "";
		else return reason;
	}
	
	/**
	 * 更新事由を設定する。
	 *
	 * @param	reason	更新事由
	 */
	public void setReason(String reason)
	{
		this.reason = reason;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

