/* $Id: DefinitionDAO.java,v 1.2 2007/11/05 09:50:54 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.SQLException;
import java.util.List;

import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

/**
 * 定義管理テーブルに対するDAOインタフェース
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface DefinitionDAO
{
	/**
	 * 主キーにより、定義情報を取得する。
	 *
	 * @param pdid 定義ID
	 * @return 定義情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public DefinitionBean findByPrimaryKey(String pdid)
	throws SQLException, DAOException;

	/**
	 * パスとプロセス定義IDで定義情報を取得する。
	 *
	 * @param path 定義ファイルへの相対パス
	 * @param ipdid プロセス定義ID
	 * @return 定義情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public DefinitionBean findByPathAndID(String path, String ipdid)
	throws SQLException, DAOException;

	/**
	 * フィルターにより特定された定義情報を取得する。
	 *
	 * @param filter フィルター
	 * @return 定義情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 * @throws InvalidFilterException 無効なフィルターが指定された場合
	 */
	public List<DefinitionBean> findByFilter(Filter filter)
	throws SQLException, DAOException, InvalidFilterException;

	/**
	 * 定義情報を挿入する。
	 *
	 * @param bean 定義情報
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public void insert(DefinitionBean bean)
	throws SQLException, DAOException;

	/**
	 * 定義情報の状態を更新する。
	 *
	 * @param pdid 定義ID
	 * @param oldState 前の状態
	 * @param newState 後の状態
	 * @throws SQLException 任意のSQL例外
	 * @throws DAOException DAO実行中に処理としてあげる場合がある例外
	 */
	public void updateState(String pdid, int oldState, int newState)
	throws SQLException, DAOException;
}
