/* $Id: DefinitionBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * DEFINITIONテーブルに対応する情報を保持するクラスである。
 *<pre><tt>
 * 項目ID        項目名             型      幅 Ｐ Ｎ
 * ------------------------------------------------------------------
 * PROC_DEF_ID   プロセス定義ID     文字列  64 ○ ○		
 * PATH          定義相対パス       文字列 128    ○		
 * INTERNAL_PDID 内部プロセス定義ID 文字列  64    ○		
 * REGISTER_DATE 登録日             日付          ○		
 * DEF_STATE     定義状態           数値     1    ○ enable/diable
 * </tt></pre>
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DefinitionBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** 定義名 */
	private String processDefinitionID;
	/** 定義相対パス */
	private String path;
	/** プロセス定義ID */
	private String internalPDID;
	/** 登録日 */
	private Timestamp registerDate;
	/** 定義状態 */
	private int state;
	
	/**
	 * 	定義情報オブジェクトを生成する。
	 *
	 */
	public DefinitionBean() {
	}
		
	/**
	 * processDefinitionIDを返す。
	 *
	 * @return processDefinitionIDの値
	 */
	public String getProcessDefinitionID()
	{
		return processDefinitionID;
	}

	/**
	 * pathを返す。
	 *
	 * @return pathの値
	 */
	public String getPath()
	{
		return path;
	}
	/**
	 * internalPDIDを返す。
	 *
	 * @return internalPDIDの値
	 */
	public String getInternalPDID()
	{
		return internalPDID;
	}

	/**
	 * registerDateを返す。
	 *
	 * @return registerDateの値
	 */
	public Timestamp getRegisterDate()
	{
		return registerDate;
	}

	/**
	 * stateを返す。
	 *
	 * @return stateの値
	 */
	public int getState()
	{
		return state;
	}

	/**
	 * processDefinitionIDを設定する。
	 * 
	 * @param processDefinitionID processDefinitionIDへの設定値
	 */
	public void setProcessDefinitionID(String processDefinitionID)
	{
		this.processDefinitionID = processDefinitionID;
	}
	
	/**
	 * pathを設定する。
	 * 
	 * @param path pathへの設定値
	 */
	public void setPath(String path)
	{
		this.path = path;
	}

	/**
	 * internalPDIDを設定する。
	 * 
	 * @param internalPDID internalPDIDへの設定値
	 */
	public void setInternalPDID(String internalPDID)
	{
		this.internalPDID = internalPDID;
	}
	
	/**
	 * registerDateを設定する。
	 * 
	 * @param registerDate registerDateへの設定値
	 */
	public void setRegisterDate(Timestamp registerDate)
	{
		this.registerDate = registerDate;
	}
	
	/**
	 * stateを設定する。
	 * 
	 * @param state stateへの設定値
	 */
	public void setState(int state)
	{
		this.state = state;
	}
}
