/* $Id: ApplicationTypeBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;

/**
 * このクラスは、アプリケーションタイプテーブル(APPLICATION_TYPE)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class ApplicationTypeBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/**
	 * アプリケーションタイプ
	 */
	protected int appType;

	/**
	 * アプリケーションタイプ名称
	 */
	protected String appTypeName;

	/**
	 * アプリケーションタイプオブジェクトを生成する。
	 */
	public ApplicationTypeBean()
	{
	}

	/**
	 * アプリケーションタイプを取得する。
	 *
	 * @return	アプリケーションタイプ
	 */
	public int getAppType()
	{
		return appType;
	}
	
	/**
	 * アプリケーションタイプを設定する。
	 *
	 * @param	appType	アプリケーションタイプ
	 */
	public void setAppType(int appType)
	{
		this.appType = appType;
	}

	/**
	 * アプリケーションタイプ名称を取得する。
	 *
	 * @return	アプリケーションタイプ名称
	 */
	public String getAppTypeName()
	{
		if (appTypeName == null) return "";
		else return appTypeName;
	}
	
	/**
	 * アプリケーションタイプ名称を設定する。
	 *
	 * @param	appTypeName	アプリケーションタイプ名称
	 */
	public void setAppTypeName(String appTypeName)
	{
		this.appTypeName = appTypeName;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

