/* $Id: AppExecutionBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.io.Serializable;
import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.ta.ApplicationState;

/**
 * このクラスは、アプリケーション実行テーブル(APP_EXECUTION)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class AppExecutionBean implements Serializable
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/**
	 * アプリケーション名
	 */
	protected String appName;

	/**
	 * アプリケーションを起動したツールエージェントのクラス名
	 */
	protected String toolAgent;

	/**
	 * ツールエージェントが発行した実行ID
	 */
	protected int execId = 0;

	/**
	 * 開始日時
	 */
	protected Timestamp startDate;

	/**
	 * 実行者
	 */
	protected String starterId;

	/**
	 * 終了日時
	 */
	protected Timestamp endDate;

	/**
	 * 実行状態
	 */
	protected ApplicationState appState;

	/**
	 * アプリケーション実行オブジェクトを生成する。
	 */
	public AppExecutionBean()
	{
	    /* Ignore */
	}

	/**
	 * アプリケーション名を取得する。
	 *
	 * @return	アプリケーション名
	 */
	public String getAppName()
	{
		if (appName == null) return "";
		else return appName;
	}
	
	/**
	 * アプリケーション名を設定する。
	 *
	 * @param	appName	アプリケーション名
	 */
	public void setAppName(String appName)
	{
		this.appName = appName;
	}

	/**
	 * アプリケーションを起動したツールエージェントのクラス名を取得する。
	 *
	 * @return	アプリケーションを起動したツールエージェントのクラス名
	 */
	public String getToolAgent()
	{
		if (toolAgent == null) return "";
		else return toolAgent;
	}
	
	/**
	 * アプリケーションを起動したツールエージェントのクラス名を設定する。
	 *
	 * @param	toolAgent	アプリケーションを起動したツールエージェントのクラス名
	 */
	public void setToolAgent(String toolAgent)
	{
		this.toolAgent = toolAgent;
	}

	/**
	 * ツールエージェントが発行した実行IDを取得する。
	 *
	 * @return	ツールエージェントが発行した実行ID
	 */
	public int getExecId()
	{
		return execId;
	}
	
	/**
	 * ツールエージェントが発行した実行IDを設定する。
	 *
	 * @param	execId	ツールエージェントが発行した実行ID
	 */
	public void setExecId(int execId)
	{
		this.execId = execId;
	}

	/**
	 * 開始日時を取得する。
	 *
	 * @return	開始日時
	 */
	public Timestamp getStartDate()
	{
		return startDate;
	}
	
	/**
	 * 開始日時を設定する。
	 *
	 * @param	startDate	開始日時
	 */
	public void setStartDate(Timestamp startDate)
	{
		this.startDate = startDate;
	}

	/**
	 * 実行者を取得する。
	 *
	 * @return	実行者
	 */
	public String getStarterId()
	{
		if (starterId == null) return "";
		else return starterId;
	}
	
	/**
	 * 実行者を設定する。
	 *
	 * @param	starterId	実行者
	 */
	public void setStarterId(String starterId)
	{
		this.starterId = starterId;
	}

	/**
	 * 終了日時を取得する。
	 *
	 * @return	終了日時
	 */
	public Timestamp getEndDate()
	{
		return endDate;
	}
	
	/**
	 * 終了日時を設定する。
	 *
	 * @param	endDate	終了日時
	 */
	public void setEndDate(Timestamp endDate)
	{
		this.endDate = endDate;
	}

	/**
	 * 実行状態を取得する。
	 *
	 * @return	実行状態
	 */
	public ApplicationState getAppState()
	{
		return appState;
	}
	
	/**
	 * 実行状態を設定する。
	 *
	 * @param	appState	実行状態
	 */
	public void setAppState(ApplicationState appState)
	{
		this.appState = appState;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

