/* $Id: ActivityBean.java,v 1.1 2007/10/29 02:55:36 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.dataaccess;

import java.sql.Timestamp;

import jp.co.argo21.nautica.workflow.wfmc.Activity;

/**
 * このクラスは、アクティビティインスタンステーブル(ACTIVITY)に対応する情報を保持する。
 *
 * @version	$Revision: 1.1 $, $Date: 2007/10/29 02:55:36 $
 * @since	Nautica Workflow 1.0
 */
public class ActivityBean implements Activity
{
	/** シリアルバージョンUID */
	private static final long serialVersionUID = 20050000000000001L;

	/** ID接頭辞 */
	public static final String ID_PREFIX  = "ACI";

	/**
	 * プロセスインスタンスID
	 */
	protected String procID;

	/**
	 * アクティビティインスタンスID
	 */
	protected String actID;

	/**
	 * アクティビティ定義ID
	 */
	protected String actDefID;

	/**
	 * 開始日時
	 */
	protected Timestamp startDate;

	/**
	 * 開始者
	 */
	protected String starterID;

	/**
	 * 実行期限
	 */
	protected Timestamp durationLimit;

	/**
	 * 所属する並行処理ブロックID
	 */
	protected String blockID;

	/**
	 * 状態
	 */
	protected int actState;

	/**
	 * 実行者ID
	 */
	protected String actorID;

	/**
	 * 最新状態更新日時
	 */
	protected Timestamp updateDate;

	/**
	 * アクティビティインスタンスオブジェクトを生成する。
	 */
	public ActivityBean()
	{
	}

	/**
	 * プロセスインスタンスIDを取得する。
	 *
	 * @return	プロセスインスタンスID
	 */
	public String getProcessID()
	{
		if (procID == null) return "";
		else return procID;
	}
	
	/**
	 * プロセスインスタンスIDを設定する。
	 *
	 * @param	procID	プロセスインスタンスID
	 */
	public void setProcessID(String procID)
	{
		this.procID = procID;
	}

	/**
	 * アクティビティインスタンスIDを取得する。
	 *
	 * @return	アクティビティインスタンスID
	 */
	public String getActivityID()
	{
		if (actID == null) return "";
		else return actID;
	}
	
	/**
	 * アクティビティインスタンスIDを設定する。
	 *
	 * @param	actID	アクティビティインスタンスID
	 */
	public void setActivityID(String actID)
	{
		this.actID = actID;
	}

	/**
	 * アクティビティインスタンス名を取得する。
	 *
	 * @return	アクティビティインスタンス名
	 */
	public String getName()
	{
		return getProcessID() + "/" + getActivityID();
	}

	/**
	 * アクティビティ定義IDを取得する。
	 *
	 * @return	アクティビティ定義ID
	 */
	public String getActivityDefinitionID()
	{
		if (actDefID == null) return "";
		else return actDefID;
	}
	
	/**
	 * アクティビティ定義IDを設定する。
	 *
	 * @param	actDefID	アクティビティ定義ID
	 */
	public void setActivityDefinitionID(String actDefID)
	{
		this.actDefID = actDefID;
	}

	/**
	 * 開始日時を取得する。
	 *
	 * @return	開始日時
	 */
	public Timestamp getStartDate()
	{
		return startDate;
	}
	
	/**
	 * 開始日時を設定する。
	 *
	 * @param	startDate	開始日時
	 */
	public void setStartDate(Timestamp startDate)
	{
		this.startDate = startDate;
	}

	/**
	 * 開始者を取得する。
	 *
	 * @return	開始者
	 */
	public String getStarterID()
	{
		if (starterID == null) return "";
		else return starterID;
	}
	
	/**
	 * 開始者を設定する。
	 *
	 * @param	starterID	開始者
	 */
	public void setStarterID(String starterID)
	{
		this.starterID = starterID;
	}

	/**
	 * 実行期限を取得する。
	 *
	 * @return	実行期限
	 */
	public Timestamp getDurationLimit()
	{
		return durationLimit;
	}
	
	/**
	 * 実行期限を設定する。
	 *
	 * @param	durationLimit	実行期限
	 */
	public void setDurationLimit(Timestamp durationLimit)
	{
		this.durationLimit = durationLimit;
	}

	/**
	 * 所属する並行処理ブロックIDを取得する。
	 *
	 * @return	所属する並行処理ブロックID
	 */
	public String getBlockID()
	{
		if (blockID == null) return "";
		else return blockID;
	}
	
	/**
	 * 所属する並行処理ブロックIDを設定する。
	 *
	 * @param	blockID	所属する並行処理ブロックID
	 */
	public void setBlockID(String blockID)
	{
		this.blockID = blockID;
	}

	/**
	 * 状態を取得する。
	 *
	 * @return	状態
	 */
	public int getActivityState()
	{
		return actState;
	}
	
	/**
	 * 状態を設定する。
	 *
	 * @param	actState	状態
	 */
	public void setActivityState(int actState)
	{
		this.actState = actState;
	}

	/**
	 * 実行者IDを取得する。
	 *
	 * @return	実行者ID
	 */
	public String getActorID()
	{
		if (actorID == null) return "";
		else return actorID;
	}
	
	/**
	 * 実行者IDを設定する。
	 *
	 * @param	actorID	実行者ID
	 */
	public void setActorID(String actorID)
	{
		this.actorID = actorID;
	}

	/**
	 * 最新状態更新日時を取得する。
	 *
	 * @return	最新状態更新日時
	 */
	public Timestamp getUpdateDate()
	{
		return updateDate;
	}
	
	/**
	 * 最新状態更新日時を設定する。
	 *
	 * @param	updateDate	最新状態更新日時
	 */
	public void setUpdateDate(Timestamp updateDate)
	{
		this.updateDate = updateDate;
	}

	/**
	 * ガーベジコレクタによる当該オブジェクトの解放処理を行う。
	 *
	 * @throws	Throwable	任意の例外
	 */
	protected void finalize() throws Throwable
	{
		// ここに独自の解放処理を実装する。
		super.finalize();
	}
	
	/**
	 * 引数のオブジェクトとの比較を行い、同一性を判定する。
	 *
	 * @param	obj	比較するオブジェクト
	 * @return	判定結果
	 */
	public boolean equals(Object obj)
	{
		boolean b = super.equals(obj);
		return b;
	}
}

