/* $Id: DefinitionRegister.java,v 1.1 2007/10/29 02:55:41 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow Core.
 * 
 *  Nautica Workflow Core is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow Core is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Nautica Workflow Core; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.client;

import org.apache.log4j.Logger;

import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;

/**
 * ワークフローシステム運用基盤への定義登録用クラスである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class DefinitionRegister
{
	/** ログ */
	private static final Logger log = Logger.getLogger(DefinitionRegister.class);

	/** バージョン */
	private static final String version = "1.0";

	/** ネーミングURL */
	private static String naming = "iiop://localhost:1050";
	/** スコープ */
	private static String scope = "";
	/** ユーザ */
	private static String user = "";
	/** パスワード */
	private static String pass = "";
	/** 管理者キー */
	@SuppressWarnings("unused")
	private static String adminKey = "";
	/** 定義名 */
	private static String defName = "";
	/** 定義ファイル相対パス */
	private static String defPath = "";
	

	/**
	 * ワークフローシステム運用基盤への定義登録用mainメソッドである。
	 *
	 * @param	args	起動時の引数
	 */
	public static void main(String[] args)
	{
		try {
			parseOption(args);
			WorkflowServiceAccessor accessor 
				= new WorkflowServiceAccessor(
						new ConnectionInfo(naming, scope, user, pass));
			String session = accessor.open();
			DefinitionRepository repository = accessor.getDefinitionRepository();
			repository.registerDefinition(session, defName, defPath);
		} catch (Exception ex) {
			DefinitionRegister.exitWithException(ex);
		}
	}

	/**
	 * 引数の判定を行う。
	 * 
	 * @param	args	起動時の引数
	 */
	private static void parseOption(String[] args)
	{
 		int argc = args.length;
		if (argc < 1) usage(null);

		int i = 0;
		while (i < argc) {
			String token = args[i];

			if (token.equals("-jndi")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				naming = args[i];
			} else if (token.equals("-scope")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				scope = args[i];
			} else if (token.equals("-u")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				user = args[i];
			} else if (token.equals("-p")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				pass = args[i];
			} else if (token.equals("-admin")) {
				i++;
				if (i == argc) usage("Invalid usage: " + token);
				adminKey = args[i];
			} else if (token.equals("-v")) {
				version();
			} else if (token.equals("-h")) {
				usage(null);
			} else if (token.startsWith("-")) {
				usage("Unknown option.: " + token);
			} else {
				break;
			}
			i++;
		}
		if (i == argc) usage("Invalid usage");
		defName = args[i];
		i++;
		if (i == argc) usage("Invalid usage");
		defPath = args[i];
	}

	/**
	 * 使用法の表示
	 *
	 * @param message エラーメッセージ。nullも可。
	 */
	private static void usage(String message)
	{
		if (message != null) System.err.println(message);

		System.err.println(
			"DefinitionRegister " + version + "\n"
			+ "Copyright (c)2005 ARGO 21, Corp. All rights reserved.\n"
			+ "Usage: java [<java options>...] "
			+ DefinitionRegister.class.getName() + "\n"
			+ "            [<OPTIONS>] <def_name> <def_path>\n\n"
			+ " OPTIONS:\n"
			+ "   -jndi <naming_url>\n"
            + "                    Naitica Workflow naming url.\n"
			+ "   -scope <scope>\n"
            + "                    Naitica Workflow naming scope.\n"
			+ "   -u <user>\n"
            + "                    Naitica Workflow user.\n"
			+ "   -p <password>\n"
            + "                    Naitica Workflow password.\n"
			+ "   -admin <admin_key>\n"
            + "                    Naitica Workflow admin key.\n"
			+ "   -v               print version.\n"
			+ "   -h               print this message.\n"
			);

		System.exit(1);
    }

	/**
	 * バージョンの表示
	 */
	private static void version()
	{
		System.err.println("DefinitionRegister version " + version);
		System.exit(0);
    }
	
	/**
	 * ワークフローシステム運用基盤への定義登録失敗処理を行う。
	 * 
	 * @param ex 任意の例外
	 */
	private static void exitWithException(Exception ex)
	{
		log.error("DefinitionRegister failed.", ex);
		ex.printStackTrace();

		System.exit(1);
	}
}
